/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

import java.util.List;


//$Id$

/**
 * A Start Event indicates where a particular Process will start. <p/> In terms of Sequence Flow, the Start Event starts
 * the Flow of the Process, and thus, will not have any incoming Sequence Flow. A Start Event can have a Trigger that
 * indicates how the Process starts: Message, Timer, Rule, Link, or Multiple.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface StartEvent extends Event, SingleOutFlowSupport
{
  /**
   * Trigger is an attribute that defines the type of trigger expected for a Start Event. Of the set of
   * EventDetailTypes, only four (4) can be applied to a Start Event: Message, Timer, Conditional, and Signal. If there
   * is no EventDetail defined, then this is considered a None Start Event and the Event will not have an internal
   * marker. If there is more than one EventDetail defined, this is considered a Multiple Start Event
   * and the Event will have the pentagon internal marker.
   */
  List<EventDetail> getTrigger();
}