/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;





//$Id$

/**
 * A Task is an Atomic Activity that is included within a Process.
 * 
 * A Task is used when the work in the Process is not broken down to a finer level of Process Model detail. Generally, an end-user and/or an application are used to
 * perform the Task when it is executed.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface Task extends Activity
{
  /**
   * The TaskType
   */
  public enum TaskType
  {
    Service, Receive, Send, User, Script, Manual, Reference, None
  }

  /**
   * TaskType is an attribute that has a default of None, but MAY be set to Send,
   * Receive, User, Script, Manual, Reference, or Service. The TaskType will be
   * impacted by the Message Flow to and/or from the Task, if Message Flow are
   * used. A TaskType of Receive MUST NOT have an outgoing Message Flow. A
   * TaskType of Send MUST NOT have an incoming Message Flow. A TaskType of
   * Script or Manual MUST NOT have an incoming or an outgoing Message Flow.
   * The TaskType list MAY be extended to include new types.
   */
  Task.TaskType getTaskType();
}