/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.client.MessageListener;
import org.jboss.bpm.client.ProcessEngine;
import org.jboss.bpm.model.Entity;
import org.jboss.bpm.model.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageManager {
    private static final Log log = LogFactory.getLog(MessageManager.class);
    private Map<ObjectName, MessageListener> listeners = new HashMap<ObjectName, MessageListener>();

    public static MessageManager locateMessageManager() {
        ProcessEngine engine = ProcessEngine.locateProcessEngine();
        return engine.getMessageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener listener) {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            if (this.hasMessageListener(listener.getID())) {
                throw new IllegalStateException("Listener already registered: " + listener.getID());
            }
            log.debug((Object)("addMessageListener: " + listener.getID()));
            this.listeners.put(listener.getID(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageListener> getMessageListeners() {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            HashSet<MessageListener> set = new HashSet<MessageListener>(this.listeners.values());
            return Collections.unmodifiableSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener getMessageListener(ObjectName listenerID) {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            return this.listeners.get(listenerID);
        }
    }

    public boolean hasMessageListener(ObjectName listenerID) {
        return this.getMessageListener(listenerID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(ObjectName listenerID) {
        Map<ObjectName, MessageListener> map = this.listeners;
        synchronized (map) {
            log.debug((Object)("removeMessageListener: " + listenerID));
            this.listeners.remove(listenerID);
        }
    }

    public abstract void sendMessage(ObjectName var1, String var2, Message var3);

    public void sendMessage(Message msg) {
        Entity toRef = msg.getToRef().getEntityRef();
        if (toRef == null) {
            throw new IllegalArgumentException("Target entity cannot be null");
        }
        MessageListener msgListener = this.getMessageListener(toRef.getName());
        if (msgListener == null) {
            throw new IllegalStateException("No message listener registered for: " + toRef);
        }
        log.debug((Object)("sendMessage to '" + toRef + "' => " + msg));
        msgListener.catchMessage(msg);
    }
}

