/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.EngineShutdownException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.client.DialectRegistry;
import org.jboss.bpm.client.ProcessEngine;
import org.jboss.bpm.model.Process;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessManager {
    private static final Log log = LogFactory.getLog(ProcessManager.class);
    protected Map<String, DialectHandler> dialectHandlers;
    protected DialectRegistry dialectRegistry;
    private Map<ObjectName, Process> procs = new HashMap<ObjectName, Process>();

    protected ProcessManager() {
    }

    public static ProcessManager locateProcessManager() {
        ProcessEngine engine = ProcessEngine.locateProcessEngine();
        return engine.getProcessManager();
    }

    public final Process createProcess(String pXML) {
        String nsURI = this.getNamespaceURI(new ByteArrayInputStream(pXML.getBytes()));
        Process proc = this.getDialectHandler(nsURI).createProcess(pXML, false);
        return proc;
    }

    public final Process createProcess(URL pURL) throws IOException {
        String nsURI = this.getNamespaceURI(pURL.openStream());
        Process proc = this.getDialectHandler(nsURI).createProcess(pURL, false);
        return proc;
    }

    public Set<Process> getProcesses() {
        HashSet<Process> procSet = new HashSet<Process>(this.procs.values());
        return Collections.unmodifiableSet(procSet);
    }

    public Set<Process> getProcesses(String name, Process.ProcessStatus status) {
        HashSet<Process> procSet = new HashSet<Process>();
        for (Process aux : this.procs.values()) {
            if (!aux.getName().equals(name) || status != null && aux.getProcessStatus() != status) continue;
            procSet.add(aux);
        }
        return procSet;
    }

    public Process getProcessByID(ObjectName procID) {
        Process proc = this.procs.get(procID);
        return proc;
    }

    public void registerProcess(Process proc) {
        if (ProcessEngine.locateProcessEngine().isPrepareForShutdown()) {
            throw new EngineShutdownException("Cannot register a process while engine is shutting down");
        }
        log.debug((Object)("registerProcess: " + proc));
        this.procs.put(proc.getID(), proc);
    }

    public void unregisterProcess(Process proc) {
        log.debug((Object)("unregisterProcess: " + proc));
        this.procs.remove(proc.getID());
    }

    private String getNamespaceURI(InputStream inStream) {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(inStream);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot parse process descriptor", ex);
        }
        Element root = doc.getDocumentElement();
        String nsURI = root.getNamespaceURI();
        if (nsURI == null) {
            throw new IllegalStateException("Cannot get namespace URI from root element");
        }
        return nsURI;
    }

    public DialectHandler getDialectHandler(String nsURI) {
        String dialectId = this.dialectRegistry.getDialect(nsURI);
        if (dialectId == null) {
            throw new IllegalStateException("No dialect registered for: " + nsURI);
        }
        DialectHandler dialectHandler = this.dialectHandlers.get(dialectId);
        if (dialectHandler == null) {
            throw new IllegalStateException("No dialect handler registered for: " + dialectId);
        }
        return dialectHandler;
    }
}

