/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.BPMException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.client.MessageListener;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.client.SignalListener;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.client.internal.EmbeddedBeansDeployer;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Signal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAPITestCase
extends TestCase {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private EmbeddedBeansDeployer deployer;
    private SignalListener signalListener;
    private MessageListener messageListener;
    private List<Signal> signals = new ArrayList<Signal>();
    private List<Message> messages = new ArrayList<Message>();

    protected abstract String getBeansConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.log.debug((Object)("setUp: " + ((Object)((Object)this)).getClass().getName() + "." + this.getName()));
        this.deployer = new EmbeddedBeansDeployer();
        this.clearAllSignalListeners();
        SignalManager sigManager = SignalManager.locateSignalManager();
        sigManager.addSignalListener(this.getSignalListener());
        List<Signal> list = this.signals;
        synchronized (list) {
            this.signals.clear();
        }
        this.clearAllMessageListeners();
        MessageManager msgManager = MessageManager.locateMessageManager();
        msgManager.addMessageListener(this.getMessageListener());
    }

    private void clearAllSignalListeners() {
        SignalManager sigManager = SignalManager.locateSignalManager();
        Set<SignalListener> sigListeners = sigManager.getSignalListeners();
        for (SignalListener sigListener : sigListeners) {
            sigManager.removeSignalListener(sigListener);
        }
    }

    private void clearAllMessageListeners() {
        MessageManager msgManager = MessageManager.locateMessageManager();
        Set<MessageListener> msgListeners = msgManager.getMessageListeners();
        for (MessageListener msgListener : msgListeners) {
            msgManager.removeMessageListener(msgListener.getID());
        }
    }

    protected void tearDown() throws Exception {
        Set<MessageListener> msgListeners;
        Set<SignalListener> sigListeners;
        this.log.debug((Object)("tearDown: " + ((Object)((Object)this)).getClass().getName() + "." + this.getName()));
        SignalManager signalManager = SignalManager.locateSignalManager();
        signalManager.removeSignalListener(this.getSignalListener());
        MessageManager messageManager = MessageManager.locateMessageManager();
        messageManager.removeMessageListener(this.getTestID());
        ProcessManager procManager = ProcessManager.locateProcessManager();
        Set<Process> procs = procManager.getProcesses();
        if (procs.size() > 0) {
            String logMsg = "Registered processes on tear down of " + this.getName() + ": " + procs;
            System.out.println(logMsg);
            this.log.warn((Object)logMsg);
        }
        if ((sigListeners = signalManager.getSignalListeners()).size() > 0) {
            String logMsg = "Registered signal listeners on tear down of " + this.getName() + ": " + sigListeners;
            System.out.println(logMsg);
            this.log.warn((Object)logMsg);
        }
        if ((msgListeners = messageManager.getMessageListeners()).size() > 0) {
            String logMsg = "Registered message listeners on tear down of " + this.getName() + ": " + msgListeners;
            System.out.println(logMsg);
            this.log.warn((Object)logMsg);
        }
        super.tearDown();
    }

    protected void deployBeans(String resourceName) {
        URL url = this.getBeansConfigURL(resourceName);
        this.deployer.deploy(url);
    }

    protected void undeployBeans(String resourceName) {
        URL url = this.getBeansConfigURL(resourceName);
        this.deployer.undeploy(url);
        this.deployer = null;
    }

    protected URL getResourceURL(String resource) {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        URL url = ctxLoader.getResource(resource);
        if (url == null) {
            throw new IllegalStateException("Cannot find resource: " + resource);
        }
        return url;
    }

    private URL getBeansConfigURL(String resourceName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            throw new BPMException("Cannot find resource: " + resourceName);
        }
        return url;
    }

    public SignalListener getSignalListener() {
        if (this.signalListener == null) {
            this.signalListener = new SignalListener(){

                public boolean acceptSignal(Signal signal) {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void catchSignal(Signal signal) {
                    List list = AbstractAPITestCase.this.signals;
                    synchronized (list) {
                        AbstractAPITestCase.this.signals.add(signal);
                    }
                }

                public String toString() {
                    return "SignalListener[" + AbstractAPITestCase.this.getShortName() + "]";
                }
            };
        }
        return this.signalListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Signal> getSignals() {
        List<Signal> list = this.signals;
        synchronized (list) {
            return Collections.unmodifiableList(this.signals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Signal> getSignals(Signal.SignalType type) {
        List<Signal> list = this.signals;
        synchronized (list) {
            ArrayList<Signal> retSignals = new ArrayList<Signal>();
            for (Signal sig : this.signals) {
                if (sig.getSignalType() != type) continue;
                retSignals.add(sig);
            }
            return Collections.unmodifiableList(retSignals);
        }
    }

    public MessageListener getMessageListener() {
        if (this.messageListener == null) {
            this.messageListener = new MessageListener(){

                public ObjectName getID() {
                    return AbstractAPITestCase.this.getTestID();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void catchMessage(Message message) {
                    List list = AbstractAPITestCase.this.messages;
                    synchronized (list) {
                        AbstractAPITestCase.this.log.debug((Object)("catchMessage: " + message));
                        AbstractAPITestCase.this.messages.add(message);
                    }
                }
            };
        }
        return this.messageListener;
    }

    public ObjectName getTestID() {
        String shortName = this.getShortName();
        shortName = shortName.replace("DescriptorTest", "Test");
        shortName = shortName.replace("MarshallerTest", "Test");
        return ObjectNameFactory.create("jboss.bpm", "test", shortName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages() {
        List<Message> list = this.messages;
        synchronized (list) {
            return Collections.unmodifiableList(this.messages);
        }
    }

    public String marshallProcess(Process proc, Writer out) {
        try {
            if (out == null) {
                File file = new File("target/" + this.getName() + "-" + this.getDialect() + ".xml");
                out = new FileWriter(file);
                System.out.println("Marshall process to: " + file.getCanonicalPath());
            }
            String procXML = this.marshallProcess(proc);
            out.write(procXML);
            out.close();
            return procXML;
        }
        catch (IOException ex) {
            throw new BPMException("Cannot marshall process", ex);
        }
    }

    public String marshallProcess(Process proc) throws IOException {
        ProcessManager procManager = ProcessManager.locateProcessManager();
        DialectHandler dialectHandler = procManager.getDialectHandler(this.getDialectURI());
        StringWriter strwr = new StringWriter();
        dialectHandler.marshallProcess(proc, strwr);
        return strwr.toString();
    }

    protected String getShortName() {
        String shortName = ((Object)((Object)this)).getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getDialect() {
        String dialect = System.getProperty("jbpm.dialect", "api10");
        return dialect;
    }

    protected String getDialectURI() {
        String dialect = System.getProperty("jbpm.dialect.uri", "urn:bpm.jboss:pdl-0.1");
        return dialect;
    }
}

