/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.bpm.test.ArchiveDeployer;
import org.jboss.bpm.test.JBossArchiveDeployer;

public class IntegrationTestHelper {
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static MBeanServerConnection server;
    private static String testArchiveDir;
    private static String testResourcesDir;

    public void deploy(String archive) throws Exception {
        URL url = this.getArchiveFile(archive).toURL();
        this.getDeployer().deploy(url);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getArchiveFile(archive).toURL();
        this.getDeployer().undeploy(url);
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private ArchiveDeployer getDeployer() {
        return new JBossArchiveDeployer(IntegrationTestHelper.getServer());
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return this.getArchiveFile(archive).toURL();
    }

    public File getArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(IntegrationTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = IntegrationTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + IntegrationTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public URL getResourceURL(String resource) throws MalformedURLException {
        return this.getResourceFile(resource).toURL();
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(IntegrationTestHelper.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + IntegrationTestHelper.getTestResourcesDir() + "/" + resource + "'");
    }

    public static String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
        }
        return testArchiveDir;
    }

    public static String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-resource");
        }
        return testResourcesDir;
    }
}

