/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.api10;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.dialect.api10.ProcessMarshaller;
import org.jboss.bpm.dialect.api10.ProcessUnmarshaller;
import org.jboss.bpm.model.Process;

public class DialectHandlerImpl
implements DialectHandler {
    public String getNamespaceURI() {
        return "urn:bpm.jboss:pdl-0.1";
    }

    public Process createProcess(String pXML, boolean isInclude) {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            Process proc = unmarschaller.unmarshallProcess(new StringReader(pXML), isInclude);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pXML, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pXML, (Throwable)ex);
        }
    }

    public Process createProcess(URL pURL, boolean isInclude) throws IOException {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            Process proc = unmarschaller.unmarshallProcess(new InputStreamReader(pURL.openStream()), isInclude);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pURL, (Throwable)ex);
        }
    }

    public void marshallProcess(Process proc, Writer out) throws IOException {
        try {
            new ProcessMarshaller().marshallProcess(proc, out);
        }
        catch (JAXBException ex) {
            IOException ioex = new IOException("Cannot marschall: " + proc);
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

