/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.HashMap;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;
import org.mvel.MVEL;

public class ExpressionEvaluator {
    private Expression expr;

    public ExpressionEvaluator(Expression expr) {
        this.expr = expr;
    }

    public Object evaluateExpression(Token token) {
        Expression.ExpressionLanguage exprLang = this.expr.getExpressionLanguage();
        if (exprLang == Expression.ExpressionLanguage.MVEL) {
            String mvel = this.expr.getExpressionBody();
            ExecutionContext exContext = token.getExecutionContext();
            HashMap<String, Object> vars = new HashMap<String, Object>();
            for (Attachments.Key key : exContext.getAttachmentKeys()) {
                String name = key.getNamePart();
                Object value = exContext.getAttachment(name);
                vars.put(name.replace(".", "_"), value);
            }
            return MVEL.eval((String)mvel, vars);
        }
        throw new IllegalStateException("Unsupported expression language: " + exprLang);
    }
}

