/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.IntermediateEvent;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.ri.model.impl.EventImpl;
import org.jboss.bpm.ri.model.impl.SingleInFlowSetterSupport;
import org.jboss.bpm.ri.model.impl.SingleOutFlowSetterSupport;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;
import org.jboss.util.id.UID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateEventImpl
extends EventImpl
implements IntermediateEvent,
SingleInFlowSetterSupport,
SingleOutFlowSetterSupport {
    private SequenceFlow inFlow;
    private SequenceFlow outFlow;
    private List<EventDetail> triggers = new ArrayList<EventDetail>();

    public IntermediateEventImpl(String name) {
        super(name);
    }

    @Override
    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("jboss.bpm:");
            str.append("type=IntermediateEvent,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public ConnectingObject getInFlow() {
        return this.inFlow;
    }

    @Override
    public void setInFlow(SequenceFlow inFlow) {
        this.inFlow = inFlow;
    }

    public SequenceFlow getOutFlow() {
        return this.outFlow;
    }

    @Override
    public void setOutFlow(SequenceFlow flow) {
        this.outFlow = flow;
    }

    public List<EventDetail> getTrigger() {
        return Collections.unmodifiableList(this.triggers);
    }

    public void addTrigger(EventDetail eventDetail) {
        this.triggers.add(eventDetail);
    }

    @Override
    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        tokenExecutor.move(token, this.getOutFlow());
    }

    @Override
    public SignalHandler getSignalHandler() {
        SignalHandler handler = super.getSignalHandler();
        if (handler == null) {
            handler = new SignalHandler(){
                SignalManager signalManager = SignalManager.locateSignalManager();

                public void throwEnterSignal(Token token) {
                    Signal signal = new Signal(IntermediateEventImpl.this.getID(), Signal.SignalType.SYSTEM_EVENT_ENTER);
                    this.signalManager.throwSignal(signal);
                }

                public void throwExitSignal(Token token) {
                    Signal signal = new Signal(IntermediateEventImpl.this.getID(), Signal.SignalType.SYSTEM_EVENT_EXIT);
                    this.signalManager.throwSignal(signal);
                }
            };
        }
        return handler;
    }

    public String toString() {
        return "ItermediateEvent[" + this.getName() + "]";
    }
}

