/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import javax.management.ObjectName;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Activity;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.ri.model.impl.ActivityImpl;
import org.jboss.bpm.ri.model.impl.SingleInFlowSetterSupport;
import org.jboss.bpm.ri.model.impl.SingleOutFlowSetterSupport;
import org.jboss.bpm.ri.model.spec.SubProcess;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.util.id.UID;

public class SubProcessImpl
extends ActivityImpl
implements SubProcess,
SingleInFlowSetterSupport,
SingleOutFlowSetterSupport {
    public SubProcessImpl(String name) {
        super(name);
    }

    public Activity.ActivityType getActivityType() {
        return Activity.ActivityType.SubProcess;
    }

    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("jboss.bpm:");
            str.append("type=SubProcess,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public SignalHandler getSignalHandler() {
        SignalHandler handler = super.getSignalHandler();
        if (handler == null) {
            handler = new SignalHandler(){
                SignalManager signalManager = SignalManager.locateSignalManager();

                public void throwEnterSignal(Token token) {
                    Signal signal = new Signal(SubProcessImpl.this.getID(), Signal.SignalType.SYSTEM_SUB_PROCESS_ENTER);
                    this.signalManager.throwSignal(signal);
                }

                public void throwExitSignal(Token token) {
                    Signal signal = new Signal(SubProcessImpl.this.getID(), Signal.SignalType.SYSTEM_SUB_PROCESS_EXIT);
                    this.signalManager.throwSignal(signal);
                }
            };
        }
        return handler;
    }

    public String toString() {
        return "SubProcess[" + this.getName() + "]";
    }
}

