/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.runtime.DelegatingToken;
import org.jboss.bpm.ri.runtime.MutableToken;
import org.jboss.bpm.ri.runtime.RuntimeProcess;
import org.jboss.bpm.runtime.HandlerSupport;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenExecutorImpl
implements TokenExecutor {
    private static final Log log = LogFactory.getLog(TokenExecutorImpl.class);
    private RuntimeProcess rtProc;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private Map<String, RunnableToken> runnableTokens = new HashMap<String, RunnableToken>();

    public TokenExecutorImpl(RuntimeProcess rtProc) {
        this.rtProc = rtProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Token> getRunnableTokens() {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            HashSet<Token> tokenSet = new HashSet<Token>();
            for (RunnableToken rt : this.runnableTokens.values()) {
                tokenSet.add(rt.getToken());
            }
            return Collections.unmodifiableSet(tokenSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRunnableTokens() {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            return this.runnableTokens.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Token token, SequenceFlow initialFlow) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setTokenStatus(Token.TokenStatus.Created);
            mutableToken.setFlow(initialFlow);
            log.debug((Object)("Create Token: " + token));
            RunnableToken rtToken = new RunnableToken(this.rtProc, mutableToken);
            this.runnableTokens.put(token.getTokenID(), rtToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Token token) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            Process.ProcessStatus procStatus = this.getProcess(token).getProcessStatus();
            if (procStatus != Process.ProcessStatus.Ready && procStatus != Process.ProcessStatus.Active) {
                throw new IllegalStateException("Cannot start token to process in state: " + procStatus);
            }
            log.debug((Object)("Sart Token: " + token));
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setTokenStatus(Token.TokenStatus.Started);
            RunnableToken rtToken = this.runnableTokens.get(token.getTokenID());
            this.executor.submit(rtToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Token token, SequenceFlow flow) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            if (flow == null) {
                throw new IllegalArgumentException("Flow cannot be null");
            }
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setFlow(flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Token token) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            log.debug((Object)("Stop Token: " + token));
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setTokenStatus(Token.TokenStatus.Stoped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Token token) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            log.debug((Object)("Destroy Token: " + token));
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setTokenStatus(Token.TokenStatus.Destroyed);
            this.runnableTokens.remove(token.getTokenID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String suspend(Token token) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            log.debug((Object)("Suspend Token: " + token));
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setTokenStatus(Token.TokenStatus.Suspended);
            return token.getTokenID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token activate(String tokenID) {
        Map<String, RunnableToken> map = this.runnableTokens;
        synchronized (map) {
            RunnableToken rtToken = this.runnableTokens.get(tokenID);
            if (rtToken == null) {
                throw new IllegalStateException("Not a runnable token: " + tokenID);
            }
            Token token = rtToken.getToken();
            if (token.getTokenStatus() != Token.TokenStatus.Suspended) {
                throw new IllegalStateException("Activate token in state: " + token.getTokenStatus());
            }
            log.debug((Object)("Activate Token: " + token));
            MutableToken mutableToken = (MutableToken)token;
            mutableToken.setTokenStatus(Token.TokenStatus.Started);
            this.executor.submit(rtToken);
            return token;
        }
    }

    private Process getProcess(Token token) {
        return token.getFlow().getTargetRef().getProcess();
    }

    class RunnableToken
    implements Runnable {
        private RuntimeProcess rtProc;
        private TokenExecutor tokenExecutor;
        private MutableToken token;

        public RunnableToken(RuntimeProcess rtProc, MutableToken token) {
            this.tokenExecutor = rtProc.getTokenExecutor();
            this.rtProc = rtProc;
            this.token = token;
        }

        public Token getToken() {
            return this.token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Process proc = this.rtProc.getProcess();
            try {
                SequenceFlow flow = this.token.getFlow();
                if (flow == null) {
                    throw new IllegalStateException("Cannot obtain initial flow");
                }
                Token.TokenStatus tokStatus = this.token.getTokenStatus();
                Process.ProcessStatus procStatus = proc.getProcessStatus();
                while (procStatus == Process.ProcessStatus.Active && tokStatus == Token.TokenStatus.Started) {
                    FlowObject flowObject = this.token.getFlow().getTargetRef();
                    FlowObjectImpl flowObjectImpl = (FlowObjectImpl)flowObject;
                    SignalHandler sigHandler = this.getSignalHandler(flowObject);
                    FlowObject flowObject2 = flowObject;
                    synchronized (flowObject2) {
                        DelegatingToken tokCopy = new DelegatingToken(this.token);
                        sigHandler.throwEnterSignal((Token)tokCopy);
                        flowObjectImpl.execute(tokCopy);
                        flowObjectImpl.executeFlowHandler(this.tokenExecutor, tokCopy);
                        sigHandler.throwExitSignal((Token)tokCopy);
                        tokStatus = this.token.getTokenStatus();
                        procStatus = proc.getProcessStatus();
                    }
                }
                this.terminateToken(proc);
            }
            catch (RuntimeException rte) {
                log.error((Object)("Process aborted: " + proc), (Throwable)rte);
                ((ProcessImpl)proc).setRuntimeException(rte);
                log.debug((Object)"Terminate all suspended tokens");
                HashSet keySet = new HashSet(TokenExecutorImpl.this.runnableTokens.keySet());
                for (String tokID : keySet) {
                    RunnableToken rtTok = (RunnableToken)TokenExecutorImpl.this.runnableTokens.get(tokID);
                    Token auxToken = rtTok.getToken();
                    if (auxToken.getTokenStatus() != Token.TokenStatus.Suspended) continue;
                    this.tokenExecutor.destroy(auxToken);
                }
                this.terminateToken(proc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminateToken(Process proc) {
            Object object = TokenExecutorImpl.this.runnableTokens;
            synchronized (object) {
                Token.TokenStatus status = this.token.getTokenStatus();
                if (status != Token.TokenStatus.Suspended && status != Token.TokenStatus.Destroyed) {
                    this.tokenExecutor.destroy((Token)this.token);
                }
            }
            object = this.rtProc;
            synchronized (object) {
                this.rtProc.notifyAll();
            }
        }

        private SignalHandler getSignalHandler(FlowObject target) {
            HandlerSupport handlerSupport = this.getHandlerSupport(target);
            SignalHandler handler = handlerSupport.getSignalHandler();
            if (handler == null) {
                throw new IllegalStateException("Cannot obtain signal handler from: " + target);
            }
            return handler;
        }

        private HandlerSupport getHandlerSupport(FlowObject fo) {
            if (!(fo instanceof HandlerSupport)) {
                throw new IllegalStateException("Flow object does not implement handler support: " + fo);
            }
            return (HandlerSupport)fo;
        }

        public String toString() {
            return this.token.toString();
        }
    }
}

