/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp;

import java.util.ArrayList;
import org.jbpt.alignment.LabelEntity;
import org.jbpt.bp.CausalBehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.hypergraph.abs.IEntity;

public class CBPRestrictedLabelAbstractor {
    public static <M, N extends IEntity> CausalBehaviouralProfile<M, LabelEntity> abstractCBPToLabels(CausalBehaviouralProfile<M, N> cbp) {
        ArrayList<LabelEntity> labels = new ArrayList<LabelEntity>();
        for (IEntity e : cbp.getEntities()) {
            if (e.getLabel().equals("")) continue;
            if (labels.contains(new LabelEntity(e.getLabel()))) {
                throw new IllegalArgumentException("Tried to abstract a CBP to labels, but the entities of the CBP do not have unique labels.");
            }
            labels.add(new LabelEntity(e.getLabel()));
        }
        CausalBehaviouralProfile result = new CausalBehaviouralProfile(cbp.getModel(), labels);
        for (IEntity t1 : cbp.getEntities()) {
            if (t1.getLabel().equals("")) continue;
            String s1 = t1.getLabel();
            int index1 = labels.indexOf(new LabelEntity(s1));
            for (IEntity t2 : cbp.getEntities()) {
                if (t2.getLabel().equals("")) continue;
                String s2 = t2.getLabel();
                int index2 = labels.indexOf(new LabelEntity(s2));
                RelSetType rel = cbp.getRelationForEntities(t1, t2);
                if (result.getMatrix()[index1][index2] == null) {
                    result.getMatrix()[index1][index2] = rel;
                } else if (result.getMatrix()[index1][index2].equals((Object)RelSetType.Exclusive)) {
                    result.getMatrix()[index1][index2] = rel;
                } else if (result.getMatrix()[index1][index2].equals((Object)RelSetType.Order)) {
                    if (rel.equals((Object)RelSetType.ReverseOrder)) {
                        result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                    } else if (rel.equals((Object)RelSetType.Interleaving)) {
                        result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                    }
                } else if (result.getMatrix()[index1][index2].equals((Object)RelSetType.ReverseOrder)) {
                    if (rel.equals((Object)RelSetType.Order)) {
                        result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                    } else if (rel.equals((Object)RelSetType.Interleaving)) {
                        result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                    }
                }
                if (!cbp.areCooccurring(t1, t2)) continue;
                result.getCooccurrenceMatrix()[index1][index2] = true;
            }
        }
        return result;
    }
}

