/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.hypergraph.abs.IEntity;

public class CausalBehaviouralProfile<M, N extends IEntity>
extends BehaviouralProfile<M, N> {
    public static final String COOCCURRENCE_SYMBOL = ">>";
    protected boolean[][] cooccurrenceMatrix;

    public CausalBehaviouralProfile(M model, List<N> entities) {
        super(model, entities);
        this.cooccurrenceMatrix = new boolean[this.entities.size()][this.entities.size()];
    }

    public CausalBehaviouralProfile(M model, Collection<N> entities) {
        this(model, (List<N>)new ArrayList<N>(entities));
    }

    public boolean areCooccurring(N n1, N n2) {
        int index1 = this.entities.indexOf(n1);
        int index2 = this.entities.indexOf(n2);
        if (index1 == -1 || index2 == -1) {
            throw new InvalidParameterException("The profile is not defined for the respective entities.");
        }
        return this.cooccurrenceMatrix[index1][index2];
    }

    public static String getSymbolForRelation(RelSetType rel) {
        String s = BehaviouralProfile.getSymbolForRelation(rel);
        return s.isEmpty() ? COOCCURRENCE_SYMBOL : s;
    }

    @Override
    public boolean equals(CausalBehaviouralProfile<M, N> profile) {
        boolean equal = super.equals(profile);
        if (!equal) {
            return equal;
        }
        for (IEntity n1 : this.entities) {
            for (IEntity n2 : this.entities) {
                equal &= this.areCooccurring(n1, n2) == profile.areCooccurring(n1, n2);
            }
        }
        return equal;
    }

    public boolean equalsForSharedNodes(CausalBehaviouralProfile<M, N> profile) {
        boolean equal = super.equals(profile);
        if (!equal) {
            return equal;
        }
        HashSet sharedNodes = new HashSet(this.getEntities());
        sharedNodes.retainAll(profile.getEntities());
        for (IEntity n1 : sharedNodes) {
            for (IEntity n2 : sharedNodes) {
                equal &= this.areCooccurring(n1, n2) == profile.areCooccurring(n1, n2);
            }
        }
        return equal;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        int k = 0;
        while (k < this.cooccurrenceMatrix.length) {
            int row = 0;
            while (row < this.cooccurrenceMatrix.length) {
                sb.append(String.valueOf(this.cooccurrenceMatrix[row][k]) + " , ");
                ++row;
            }
            sb.append("\n");
            ++k;
        }
        sb.append("------------------------------------------\n");
        return sb.toString();
    }

    public boolean[][] getCooccurrenceMatrix() {
        return this.cooccurrenceMatrix;
    }

    public void setCooccurrenceMatrix(boolean[][] cooccurrenceMatrix) {
        this.cooccurrenceMatrix = cooccurrenceMatrix;
    }
}

