/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp;

import java.util.ArrayList;
import org.jbpt.alignment.LabelEntity;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.hypergraph.abs.IEntity;

public class RelSetLabelAbstractor {
    public static <M, N extends IEntity> RelSet<M, LabelEntity> abstractRelSetToLabels(RelSet<M, N> rs) {
        ArrayList<LabelEntity> labels = new ArrayList<LabelEntity>();
        for (IEntity e : rs.getEntities()) {
            if (labels.contains(new LabelEntity(e.getLabel()))) continue;
            labels.add(new LabelEntity(e.getLabel()));
        }
        RelSet result = new RelSet(rs.getModel(), labels);
        for (IEntity t1 : rs.getEntities()) {
            String s1 = t1.getLabel();
            int index1 = labels.indexOf(new LabelEntity(s1));
            for (IEntity t2 : rs.getEntities()) {
                String s2 = t2.getLabel();
                int index2 = labels.indexOf(new LabelEntity(s2));
                RelSetType rel = rs.getRelationForEntities(t1, t2);
                if (result.getMatrix()[index1][index2] == null) {
                    result.getMatrix()[index1][index2] = rel;
                    continue;
                }
                if (result.getMatrix()[index1][index2].equals((Object)RelSetType.Exclusive)) {
                    result.getMatrix()[index1][index2] = rel;
                    continue;
                }
                if (result.getMatrix()[index1][index2].equals((Object)RelSetType.Order)) {
                    if (rel.equals((Object)RelSetType.ReverseOrder)) {
                        result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                        continue;
                    }
                    if (!rel.equals((Object)RelSetType.Interleaving)) continue;
                    result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                    continue;
                }
                if (!result.getMatrix()[index1][index2].equals((Object)RelSetType.ReverseOrder)) continue;
                if (rel.equals((Object)RelSetType.Order)) {
                    result.getMatrix()[index1][index2] = RelSetType.Interleaving;
                    continue;
                }
                if (!rel.equals((Object)RelSetType.Interleaving)) continue;
                result.getMatrix()[index1][index2] = RelSetType.Interleaving;
            }
        }
        return result;
    }
}

