/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.Collection;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.graph.abs.IDirectedGraph;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.PetriNet;
import org.jbpt.petri.behavior.ConcurrencyRelation;

public class BPCreatorNet
extends AbstractRelSetCreator
implements RelSetCreator<NetSystem, Node> {
    private static BPCreatorNet eInstance;

    public static BPCreatorNet getInstance() {
        if (eInstance == null) {
            eInstance = new BPCreatorNet();
        }
        return eInstance;
    }

    private BPCreatorNet() {
    }

    @Override
    public BehaviouralProfile<NetSystem, Node> deriveRelationSet(NetSystem pn) {
        return this.deriveRelationSet(pn, (Collection<Node>)pn.getNodes());
    }

    @Override
    public BehaviouralProfile<NetSystem, Node> deriveRelationSet(NetSystem pn, Collection<Node> nodes) {
        if (!PetriNet.STRUCTURAL_CHECKS.isWorkflowNet((IPetriNet)pn)) {
            throw new IllegalArgumentException();
        }
        BehaviouralProfile<NetSystem, Node> profile = new BehaviouralProfile<NetSystem, Node>(pn, nodes);
        RelSetType[][] matrix = profile.getMatrix();
        ConcurrencyRelation concurrencyRelation = new ConcurrencyRelation(pn);
        for (Node n1 : profile.getEntities()) {
            int index1 = profile.getEntities().indexOf(n1);
            for (Node n2 : profile.getEntities()) {
                int index2 = profile.getEntities().indexOf(n2);
                if (index2 > index1) continue;
                if (index1 == index2) {
                    if (PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n1, (IVertex)n2)) {
                        matrix[index1][index1] = RelSetType.Interleaving;
                        continue;
                    }
                    matrix[index1][index1] = RelSetType.Exclusive;
                    continue;
                }
                if (PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n1, (IVertex)n2) && PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n2, (IVertex)n1)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (concurrencyRelation.areConcurrent(index1, index2)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (!(concurrencyRelation.areConcurrent(index1, index2) || PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n1, (IVertex)n2) || PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n2, (IVertex)n1))) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
                    continue;
                }
                if (PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n1, (IVertex)n2) && !PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n2, (IVertex)n1)) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                if (!PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n2, (IVertex)n1) || PetriNet.DIRECTED_GRAPH_ALGORITHMS.hasPath((IDirectedGraph)pn, (IVertex)n1, (IVertex)n2)) continue;
                super.setMatrixEntryOrder(matrix, index2, index1);
            }
        }
        return profile;
    }
}

