/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.bp.construct.WFTreeHandler;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;

public class BPCreatorTree
extends AbstractRelSetCreator
implements RelSetCreator<NetSystem, Node> {
    private static BPCreatorTree eInstance;

    public static BPCreatorTree getInstance() {
        if (eInstance == null) {
            eInstance = new BPCreatorTree();
        }
        return eInstance;
    }

    private BPCreatorTree() {
    }

    @Override
    public BehaviouralProfile<NetSystem, Node> deriveRelationSet(NetSystem pn) {
        return this.deriveRelationSet(pn, (Collection<Node>)new ArrayList<Node>(pn.getTransitions()));
    }

    @Override
    public BehaviouralProfile<NetSystem, Node> deriveRelationSet(NetSystem pn, Collection<Node> nodes) {
        NetSystem netClone = null;
        HashMap<Node, Node> nodeMapping = new HashMap<Node, Node>();
        netClone = (NetSystem)pn.clone(nodeMapping);
        if (netClone == null) {
            netClone = pn;
            for (Node n : pn.getNodes()) {
                nodeMapping.put(n, n);
            }
        }
        WFTreeHandler wfTreeHandler = new WFTreeHandler(netClone);
        BehaviouralProfile<NetSystem, Node> profile = new BehaviouralProfile<NetSystem, Node>(pn, nodes);
        RelSetType[][] matrix = profile.getMatrix();
        for (Node t1 : profile.getEntities()) {
            int index1 = profile.getEntities().indexOf(t1);
            for (Node t2 : profile.getEntities()) {
                int index2 = profile.getEntities().indexOf(t2);
                if (index2 > index1) continue;
                if (wfTreeHandler.areExclusive((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
                    continue;
                }
                if (wfTreeHandler.areInterleaving((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (!wfTreeHandler.areInOrder((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) continue;
                if (wfTreeHandler.areInStrictOrder((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                super.setMatrixEntryOrder(matrix, index2, index1);
            }
        }
        return profile;
    }
}

