/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.CausalBehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.CBPCreator;
import org.jbpt.bp.construct.WFTreeHandler;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;

public class CBPCreatorTree
extends AbstractRelSetCreator
implements CBPCreator<NetSystem, Node> {
    private static CBPCreatorTree eInstance;

    public static CBPCreatorTree getInstance() {
        if (eInstance == null) {
            eInstance = new CBPCreatorTree();
        }
        return eInstance;
    }

    private CBPCreatorTree() {
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(NetSystem pn) {
        return this.deriveCausalBehaviouralProfile(pn, (Collection<Node>)new ArrayList<Node>(pn.getTransitions()));
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(NetSystem pn, Collection<Node> nodes) {
        NetSystem netClone = null;
        HashMap<Node, Node> nodeMapping = new HashMap<Node, Node>();
        netClone = (NetSystem)pn.clone(nodeMapping);
        if (netClone == null) {
            netClone = pn;
            for (Node n : pn.getNodes()) {
                nodeMapping.put(n, n);
            }
        }
        WFTreeHandler wfTreeHandler = new WFTreeHandler(netClone);
        CausalBehaviouralProfile<NetSystem, Node> profile = new CausalBehaviouralProfile<NetSystem, Node>(pn, nodes);
        RelSetType[][] matrix = profile.getMatrix();
        boolean[][] cooccurrenceMatrix = profile.getCooccurrenceMatrix();
        for (Node t1 : profile.getEntities()) {
            int index1 = profile.getEntities().indexOf(t1);
            for (Node t2 : profile.getEntities()) {
                int index2 = profile.getEntities().indexOf(t2);
                if (wfTreeHandler.areCooccurring((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    cooccurrenceMatrix[index1][index2] = true;
                }
                if (index2 > index1) continue;
                if (wfTreeHandler.areExclusive((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
                    continue;
                }
                if (wfTreeHandler.areInterleaving((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (!wfTreeHandler.areInOrder((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) continue;
                if (wfTreeHandler.areInStrictOrder((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                super.setMatrixEntryOrder(matrix, index2, index1);
            }
        }
        return profile;
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(BehaviouralProfile<NetSystem, Node> bp) {
        NetSystem pn = (NetSystem)bp.getModel();
        NetSystem netClone = null;
        HashMap nodeMapping = new HashMap();
        netClone = (NetSystem)pn.clone(nodeMapping);
        if (netClone == null) {
            netClone = pn;
        }
        WFTreeHandler wfTreeHandler = new WFTreeHandler(netClone);
        CausalBehaviouralProfile<NetSystem, Node> profile = new CausalBehaviouralProfile<NetSystem, Node>(pn, (List<Node>)bp.getEntities());
        profile.setMatrix(bp.getMatrix());
        boolean[][] cooccurrenceMatrix = profile.getCooccurrenceMatrix();
        for (Node t1 : profile.getEntities()) {
            int index1 = profile.getEntities().indexOf(t1);
            for (Node t2 : profile.getEntities()) {
                int index2 = profile.getEntities().indexOf(t2);
                if (!wfTreeHandler.areCooccurring((Node)nodeMapping.get(t1), (Node)nodeMapping.get(t2))) continue;
                cooccurrenceMatrix[index1][index2] = true;
            }
        }
        return profile;
    }
}

