/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.petri.Flow;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.Marking;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;
import org.jbpt.petri.behavior.ProjectedStateSpace;

public class ProjTARCreatorStateSpace
extends AbstractRelSetCreator
implements RelSetCreator<NetSystem, Node> {
    private static ProjTARCreatorStateSpace eInstance;
    protected ProjectedStateSpace<Flow, Node, Place, Transition, Marking> space;

    public static ProjTARCreatorStateSpace getInstance() {
        if (eInstance == null) {
            eInstance = new ProjTARCreatorStateSpace();
        }
        return eInstance;
    }

    private ProjTARCreatorStateSpace() {
    }

    protected void clear() {
        this.space = null;
    }

    @Override
    public RelSet<NetSystem, Node> deriveRelationSet(NetSystem pn) {
        return this.deriveRelationSet(pn, (Collection<Node>)new ArrayList<Node>(pn.getTransitions()));
    }

    @Override
    public RelSet<NetSystem, Node> deriveRelationSet(NetSystem pn, Collection<Node> nodes) {
        this.clear();
        HashSet<Transition> selectedTransitions = new HashSet<Transition>();
        for (Node t : nodes) {
            if (!(t instanceof Transition)) continue;
            selectedTransitions.add((Transition)t);
        }
        nodes.retainAll(selectedTransitions);
        this.space = new ProjectedStateSpace((INetSystem)pn, selectedTransitions);
        this.space.create();
        RelSet<NetSystem, Node> rs = new RelSet<NetSystem, Node>(pn, nodes, 1);
        RelSetType[][] matrix = rs.getMatrix();
        for (Node t1 : rs.getEntities()) {
            int index1 = rs.getEntities().indexOf(t1);
            for (Node t2 : rs.getEntities()) {
                int index2 = rs.getEntities().indexOf(t2);
                if (index2 > index1) continue;
                if (this.space.isStep((INode)t1, (INode)t2) && this.space.isStep((INode)t2, (INode)t1)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (this.space.isStep((INode)t1, (INode)t2)) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                if (this.space.isStep((INode)t2, (INode)t1)) {
                    super.setMatrixEntryOrder(matrix, index2, index1);
                    continue;
                }
                super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
            }
        }
        return rs;
    }
}

