/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.petri.log.Log;
import org.jbpt.petri.log.Trace;
import org.jbpt.petri.log.TraceEntry;

public class RelSetCreatorLog
extends AbstractRelSetCreator
implements RelSetCreator<Log, TraceEntry> {
    private static RelSetCreatorLog eInstance;
    protected boolean[][] baseOrderMatrix;
    protected List<TraceEntry> entriesForBaseOrderMatrix;

    public static RelSetCreatorLog getInstance() {
        if (eInstance == null) {
            eInstance = new RelSetCreatorLog();
        }
        return eInstance;
    }

    private RelSetCreatorLog() {
    }

    @Override
    public RelSet<Log, TraceEntry> deriveRelationSet(Log log) {
        return this.deriveRelationSet(log, (Collection<TraceEntry>)new ArrayList<TraceEntry>(log.getEntities()));
    }

    public RelSet<Log, TraceEntry> deriveRelationSet(Log log, int lookAhead) {
        return this.deriveRelationSet(log, new ArrayList<TraceEntry>(log.getEntities()), lookAhead);
    }

    @Override
    public RelSet<Log, TraceEntry> deriveRelationSet(Log log, Collection<TraceEntry> entries) {
        return this.deriveRelationSet(log, entries, 100000);
    }

    public RelSet<Log, TraceEntry> deriveRelationSet(Log log, Collection<TraceEntry> entries, int lookAhead) {
        this.entriesForBaseOrderMatrix = new ArrayList<TraceEntry>(entries);
        RelSet<Log, TraceEntry> rs = new RelSet<Log, TraceEntry>(log, entries, lookAhead);
        RelSetType[][] matrix = rs.getMatrix();
        this.deriveBaseOrderRelation(rs);
        for (TraceEntry s1 : rs.getEntities()) {
            int index1 = rs.getEntities().indexOf((Object)s1);
            for (TraceEntry s2 : rs.getEntities()) {
                int index2 = rs.getEntities().indexOf((Object)s2);
                if (index2 > index1) continue;
                if (this.isBaseOrder(s1, s2) && this.isBaseOrder(s2, s1)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (this.isBaseOrder(s1, s2)) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                if (this.isBaseOrder(s2, s1)) {
                    super.setMatrixEntryOrder(matrix, index2, index1);
                    continue;
                }
                super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
            }
        }
        return rs;
    }

    protected void deriveBaseOrderRelation(RelSet<Log, TraceEntry> rs) {
        this.baseOrderMatrix = new boolean[this.entriesForBaseOrderMatrix.size()][this.entriesForBaseOrderMatrix.size()];
        for (Trace t1 : rs.getModel().getTraces()) {
            int i = 0;
            while (i < t1.getLength()) {
                TraceEntry s1 = t1.getTraceAsList().get(i);
                int j = i + 1;
                while (j < t1.getLength()) {
                    TraceEntry s2 = t1.getTraceAsList().get(j);
                    if (j - i <= rs.getLookAhead()) {
                        this.addToRelation(this.baseOrderMatrix, s1, s2);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean isBaseOrder(TraceEntry s1, TraceEntry s2) {
        return this.baseOrderMatrix[this.entriesForBaseOrderMatrix.indexOf((Object)s1)][this.entriesForBaseOrderMatrix.indexOf((Object)s2)];
    }

    private void addToRelation(boolean[][] matrix, TraceEntry s1, TraceEntry s2) {
        matrix[this.entriesForBaseOrderMatrix.indexOf((Object)((Object)s1))][this.entriesForBaseOrderMatrix.indexOf((Object)((Object)s2))] = true;
    }
}

