/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.petri.log.Trace;
import org.jbpt.petri.log.TraceEntry;

public class RelSetCreatorTrace
extends AbstractRelSetCreator
implements RelSetCreator<Trace, TraceEntry> {
    private static RelSetCreatorTrace eInstance;
    protected boolean[][] baseOrderMatrix;
    protected List<TraceEntry> entriesForBaseOrderMatrix;

    public static RelSetCreatorTrace getInstance() {
        if (eInstance == null) {
            eInstance = new RelSetCreatorTrace();
        }
        return eInstance;
    }

    private RelSetCreatorTrace() {
    }

    @Override
    public RelSet<Trace, TraceEntry> deriveRelationSet(Trace trace) {
        return this.deriveRelationSet(trace, (Collection<TraceEntry>)new ArrayList<TraceEntry>(trace.getEntities()));
    }

    public RelSet<Trace, TraceEntry> deriveRelationSet(Trace trace, int lookAhead) {
        return this.deriveRelationSet(trace, new ArrayList<TraceEntry>(trace.getEntities()), lookAhead);
    }

    @Override
    public RelSet<Trace, TraceEntry> deriveRelationSet(Trace trace, Collection<TraceEntry> entries) {
        return this.deriveRelationSet(trace, entries, 100000);
    }

    public RelSet<Trace, TraceEntry> deriveRelationSet(Trace trace, Collection<TraceEntry> entries, int lookAhead) {
        this.entriesForBaseOrderMatrix = new ArrayList<TraceEntry>(entries);
        RelSet<Trace, TraceEntry> rs = new RelSet<Trace, TraceEntry>(trace, entries, lookAhead);
        RelSetType[][] matrix = rs.getMatrix();
        this.deriveBaseOrderRelation(rs);
        for (TraceEntry s1 : rs.getEntities()) {
            int index1 = rs.getEntities().indexOf((Object)s1);
            for (TraceEntry s2 : rs.getEntities()) {
                int index2 = rs.getEntities().indexOf((Object)s2);
                if (index2 > index1) continue;
                if (this.isBaseOrder(s1, s2) && this.isBaseOrder(s2, s1)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (this.isBaseOrder(s1, s2)) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                if (this.isBaseOrder(s2, s1)) {
                    super.setMatrixEntryOrder(matrix, index2, index1);
                    continue;
                }
                super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
            }
        }
        return rs;
    }

    protected void deriveBaseOrderRelation(RelSet<Trace, TraceEntry> rs) {
        this.baseOrderMatrix = new boolean[this.entriesForBaseOrderMatrix.size()][this.entriesForBaseOrderMatrix.size()];
        int i = 0;
        while (i < rs.getEntities().size()) {
            TraceEntry s1 = (TraceEntry)((Object)rs.getEntities().get(i));
            int j = i + 1;
            while (j < rs.getEntities().size()) {
                TraceEntry s2 = (TraceEntry)((Object)rs.getEntities().get(j));
                if (j - i <= rs.getLookAhead()) {
                    this.addToRelation(this.baseOrderMatrix, s1, s2);
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean isBaseOrder(TraceEntry s1, TraceEntry s2) {
        return this.baseOrderMatrix[this.entriesForBaseOrderMatrix.indexOf((Object)s1)][this.entriesForBaseOrderMatrix.indexOf((Object)s2)];
    }

    private void addToRelation(boolean[][] matrix, TraceEntry s1, TraceEntry s2) {
        matrix[this.entriesForBaseOrderMatrix.indexOf((Object)((Object)s1))][this.entriesForBaseOrderMatrix.indexOf((Object)((Object)s2))] = true;
    }
}

