/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jbpt.algo.tree.rpst.IRPSTNode;
import org.jbpt.algo.tree.tctree.TCType;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.CausalBehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.BPCreatorNet;
import org.jbpt.bp.construct.CBPCreatorNet;
import org.jbpt.graph.abs.IFragment;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.Flow;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.Marking;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.PetriNet;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;
import org.jbpt.petri.wftree.AbstractWFTree;
import org.jbpt.petri.wftree.WFTree;
import org.jbpt.petri.wftree.WFTreeBondType;
import org.jbpt.petri.wftree.WFTreeLoopOrientationType;

public class WFTreeHandler {
    private AbstractWFTree<Flow, Node, Place, Transition> wfTree = null;
    private Map<Node, IRPSTNode<Flow, Node>> node2wfTreeNode = new HashMap<Node, IRPSTNode<Flow, Node>>();
    private Map<IRPSTNode<Flow, Node>, BehaviouralProfile<NetSystem, Node>> node2bp = new HashMap<IRPSTNode<Flow, Node>, BehaviouralProfile<NetSystem, Node>>();
    private Map<IRPSTNode<Flow, Node>, CausalBehaviouralProfile<NetSystem, Node>> node2cbp = new HashMap<IRPSTNode<Flow, Node>, CausalBehaviouralProfile<NetSystem, Node>>();
    private Map<BehaviouralProfile<NetSystem, Node>, Map<Node, Node>> bp2nodemapping = new HashMap<BehaviouralProfile<NetSystem, Node>, Map<Node, Node>>();
    private Map<IRPSTNode<Flow, Node>, Vector<IRPSTNode<Flow, Node>>> orderedPNodes = new HashMap<IRPSTNode<Flow, Node>, Vector<IRPSTNode<Flow, Node>>>();

    public WFTreeHandler(NetSystem netClone) {
        PetriNet.TRANSFORMATIONS.isolateTransitions((IPetriNet)netClone);
        this.wfTree = new WFTree((IPetriNet)netClone);
        if (!PetriNet.STRUCTURAL_CHECKS.isWorkflowNet((IPetriNet)netClone)) {
            throw new IllegalArgumentException();
        }
        for (IRPSTNode node : this.wfTree.getRPSTNodes()) {
            if (!(node.getEntry() instanceof Transition)) continue;
            this.node2wfTreeNode.put((Node)((Transition)node.getEntry()), (IRPSTNode<Flow, Node>)node);
        }
    }

    public int getOrder(IRPSTNode<Flow, Node> node) {
        if (this.wfTree.getParent(node) == null || ((IRPSTNode)this.wfTree.getParent(node)).getType() != TCType.POLYGON || !this.orderedPNodes.containsKey(this.wfTree.getParent(node))) {
            return -1;
        }
        return this.orderedPNodes.get(this.wfTree.getParent(node)).lastIndexOf(node);
    }

    private boolean areInSeries(IRPSTNode<Flow, Node> lca, IRPSTNode<Flow, Node> a, IRPSTNode<Flow, Node> b) {
        if (lca.getType() != TCType.POLYGON) {
            return false;
        }
        List pathA = this.wfTree.getDownwardPath(lca, a);
        List pathB = this.wfTree.getDownwardPath(lca, b);
        if (pathA.size() < 2 || pathB.size() < 2) {
            return false;
        }
        List children = this.wfTree.getPolygonChildren(lca);
        return children.indexOf(pathA.get(1)) < children.indexOf(pathB.get(1));
    }

    public boolean areInStrictOrder(Node t1, Node t2) {
        IRPSTNode<Flow, Node> beta;
        IRPSTNode<Flow, Node> alpha = this.node2wfTreeNode.get(t1);
        if (alpha.equals(beta = this.node2wfTreeNode.get(t2))) {
            return false;
        }
        IRPSTNode gamma = (IRPSTNode)this.wfTree.getLCA(alpha, beta);
        List path = this.wfTree.getDownwardPath((IVertex)((IRPSTNode)this.wfTree.getRoot()), (IVertex)gamma);
        int i = 0;
        while (i < path.size() - 1) {
            if (this.wfTree.getRefinedBondType((IRPSTNode)path.get(i)) == WFTreeBondType.LOOP) {
                return false;
            }
            if (((IRPSTNode)path.get(i)).getType() == TCType.RIGID && this.isChildInLoop((IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i)), (IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i + 1)))) {
                return false;
            }
            ++i;
        }
        if (gamma.getType() == TCType.RIGID) {
            return this.areInStrictOrderUType(t1, t2, (IRPSTNode<Flow, Node>)gamma);
        }
        if (gamma.getType() != TCType.POLYGON) {
            return false;
        }
        return this.areInSeries((IRPSTNode<Flow, Node>)gamma, alpha, beta);
    }

    public boolean areInOrder(Node t1, Node t2) {
        return this.areInStrictOrder(t1, t2) || this.areInStrictOrder(t2, t1);
    }

    public boolean areExclusive(Node t1, Node t2) {
        IRPSTNode<Flow, Node> alpha = this.node2wfTreeNode.get(t1);
        IRPSTNode<Flow, Node> beta = this.node2wfTreeNode.get(t2);
        IRPSTNode gamma = (IRPSTNode)this.wfTree.getLCA(alpha, beta);
        List path = this.wfTree.getDownwardPath((IVertex)((IRPSTNode)this.wfTree.getRoot()), (IVertex)gamma);
        int i = 0;
        while (i < path.size() - 1) {
            if (this.wfTree.getRefinedBondType((IRPSTNode)path.get(i)) == WFTreeBondType.LOOP) {
                return false;
            }
            if (((IRPSTNode)path.get(i)).getType() == TCType.RIGID && this.isChildInLoop((IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i)), (IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i + 1)))) {
                return false;
            }
            ++i;
        }
        if (gamma.getType() == TCType.RIGID) {
            return this.areExclusiveUType(t1, t2, (IRPSTNode<Flow, Node>)gamma);
        }
        if (this.wfTree.getRefinedBondType(gamma) == WFTreeBondType.PLACE_BORDERED) {
            return true;
        }
        return alpha.equals(beta);
    }

    public boolean areInterleaving(Node t1, Node t2) {
        IRPSTNode<Flow, Node> alpha = this.node2wfTreeNode.get(t1);
        IRPSTNode<Flow, Node> beta = this.node2wfTreeNode.get(t2);
        IRPSTNode gamma = (IRPSTNode)this.wfTree.getLCA(alpha, beta);
        List path = this.wfTree.getDownwardPath((IVertex)((IRPSTNode)this.wfTree.getRoot()), (IVertex)gamma);
        int i = 0;
        while (i < path.size() - 1) {
            if (this.wfTree.getRefinedBondType((IRPSTNode)path.get(i)) == WFTreeBondType.LOOP) {
                return true;
            }
            if (((IRPSTNode)path.get(i)).getType() == TCType.RIGID && this.isChildInLoop((IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i)), (IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i + 1)))) {
                return true;
            }
            ++i;
        }
        if (gamma.getType() == TCType.RIGID) {
            return this.areInterleavingUType(t1, t2, (IRPSTNode<Flow, Node>)gamma);
        }
        WFTreeBondType gammaBlockType = this.wfTree.getRefinedBondType(gamma);
        return gammaBlockType == WFTreeBondType.TRANSITION_BORDERED || gammaBlockType == WFTreeBondType.LOOP;
    }

    public boolean areCooccurring(Node t1, Node t2) {
        IRPSTNode<Flow, Node> beta;
        IRPSTNode<Flow, Node> alpha = this.node2wfTreeNode.get(t1);
        if (alpha.equals(beta = this.node2wfTreeNode.get(t2))) {
            return true;
        }
        IRPSTNode gamma = (IRPSTNode)this.wfTree.getLCA(alpha, beta);
        if (gamma == null || t1 == null || t2 == null) {
            System.out.println(this.wfTree);
            System.out.println(this.wfTree.toDOT());
            System.exit(-1);
        }
        if (gamma.getType() == TCType.RIGID) {
            return this.areCooccurringUType(t1, t2, (IRPSTNode<Flow, Node>)gamma);
        }
        List path = this.wfTree.getDownwardPath((IVertex)gamma, beta);
        int i = 0;
        while (i < path.size() - 1) {
            if (((IRPSTNode)path.get(i)).getType() != TCType.POLYGON && this.wfTree.getRefinedBondType((IRPSTNode)path.get(i)) != WFTreeBondType.TRANSITION_BORDERED && (this.wfTree.getRefinedBondType((IRPSTNode)path.get(i)) != WFTreeBondType.LOOP || this.wfTree.getLoopOrientationType((IRPSTNode)path.get(i + 1)) != WFTreeLoopOrientationType.FORWARD)) {
                if (((IRPSTNode)path.get(i)).getType() == TCType.RIGID) {
                    Node entryOfUtype = (Node)((IRPSTNode)path.get(i)).getEntry();
                    boolean allCooccurring = true;
                    if (entryOfUtype instanceof Place) {
                        for (Node n : this.wfTree.getGraph().getDirectSuccessors((IVertex)entryOfUtype)) {
                            if (this.wfTree.getDownwardPath((IVertex)((IRPSTNode)path.get(i)), this.node2wfTreeNode.get(n)).isEmpty()) continue;
                            allCooccurring &= this.areCooccurringUType(n, t2, (IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i)));
                        }
                    } else {
                        allCooccurring = this.areCooccurringUType(entryOfUtype, t2, (IRPSTNode<Flow, Node>)((IRPSTNode)path.get(i)));
                    }
                    if (!allCooccurring) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isChildInLoop(IRPSTNode<Flow, Node> parent, IRPSTNode<Flow, Node> child) {
        HashSet<Node> visited = new HashSet<Node>();
        Set searchGraph = this.wfTree.getChildren(parent);
        LinkedList<Node> queue = new LinkedList<Node>();
        Node start = (Node)child.getExit();
        Node end = (Node)child.getEntry();
        visited.add(start);
        queue.add(start);
        while (queue.size() > 0) {
            Node n = (Node)queue.poll();
            for (IRPSTNode edge : searchGraph) {
                Node k;
                if (edge.getEntry() != n || visited.contains(k = (Node)edge.getExit())) continue;
                if (k.equals((Object)end)) {
                    return true;
                }
                visited.add(k);
                queue.add(k);
            }
        }
        return false;
    }

    private BehaviouralProfile<NetSystem, Node> getBPForFragment(IRPSTNode<Flow, Node> treeNode) {
        IFragment fragment = treeNode.getFragment();
        NetSystem net = new NetSystem();
        HashMap<Node, Place> nodeCopies = new HashMap<Node, Place>();
        try {
            HashSet<Node> fNodes = new HashSet<Node>();
            for (Flow f : fragment) {
                fNodes.add((Node)f.getSource());
                fNodes.add((Node)f.getTarget());
            }
            for (Node n : fNodes) {
                Place c;
                if (n instanceof Place) {
                    c = (Place)((Place)n).clone();
                    net.addNode((INode)c);
                    nodeCopies.put(n, c);
                    continue;
                }
                c = (Transition)((Transition)n).clone();
                net.addNode((INode)c);
                nodeCopies.put(n, c);
            }
            for (Flow f : fragment) {
                net.addFlow((Node)nodeCopies.get(f.getSource()), (Node)nodeCopies.get(f.getTarget()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Node entryNode = (Node)treeNode.getEntry();
        Node exitNode = (Node)treeNode.getExit();
        if (net.getDirectPredecessors((IVertex)entryNode).size() != 0 || entryNode instanceof Transition) {
            Place init = new Place();
            net.addNode((INode)init);
            if (entryNode instanceof Place) {
                Transition initT = new Transition();
                net.addNode((INode)initT);
                net.addFlow((IPlace)init, (ITransition)initT);
                net.addFlow((Node)initT, (Node)nodeCopies.get(entryNode));
            } else {
                net.addFlow((Node)init, (Node)nodeCopies.get(entryNode));
            }
        }
        if (net.getDirectSuccessors((IVertex)exitNode).size() != 0 || exitNode instanceof Transition) {
            Place exit = new Place();
            net.addNode((INode)exit);
            if (exitNode instanceof Place) {
                Transition exitT = new Transition();
                net.addNode((INode)exitT);
                net.addFlow((Node)nodeCopies.get(exitNode), (Node)exitT);
                net.addFlow((ITransition)exitT, (IPlace)exit);
            } else {
                net.addFlow((Node)nodeCopies.get(exitNode), (Node)exit);
            }
        }
        ((Marking)net.getMarking()).put((IPlace)((Place)net.getSourcePlaces().iterator().next()), Integer.valueOf(1));
        BehaviouralProfile<NetSystem, Node> bp = BPCreatorNet.getInstance().deriveRelationSet(net);
        this.bp2nodemapping.put(bp, nodeCopies);
        return bp;
    }

    private boolean areExclusiveUType(Node t1, Node t2, IRPSTNode<Flow, Node> fragment) {
        if (!this.node2bp.containsKey(fragment)) {
            this.node2bp.put(fragment, this.getBPForFragment(fragment));
        }
        BehaviouralProfile<NetSystem, Node> bp = this.node2bp.get(fragment);
        return bp.areExclusive(this.bp2nodemapping.get(bp).get(t1), this.bp2nodemapping.get(bp).get(t2));
    }

    private boolean areInterleavingUType(Node t1, Node t2, IRPSTNode<Flow, Node> fragment) {
        if (!this.node2bp.containsKey(fragment)) {
            this.node2bp.put(fragment, this.getBPForFragment(fragment));
        }
        BehaviouralProfile<NetSystem, Node> bp = this.node2bp.get(fragment);
        return bp.areInterleaving(this.bp2nodemapping.get(bp).get(t1), this.bp2nodemapping.get(bp).get(t2));
    }

    private boolean areInStrictOrderUType(Node t1, Node t2, IRPSTNode<Flow, Node> fragment) {
        if (!this.node2bp.containsKey(fragment)) {
            this.node2bp.put(fragment, this.getBPForFragment(fragment));
        }
        BehaviouralProfile<NetSystem, Node> bp = this.node2bp.get(fragment);
        return bp.areInOrder(this.bp2nodemapping.get(bp).get(t1), this.bp2nodemapping.get(bp).get(t2));
    }

    private CausalBehaviouralProfile<NetSystem, Node> getCBPForFragment(IRPSTNode<Flow, Node> treeNode) {
        BehaviouralProfile<NetSystem, Node> bp = this.getBPForFragment(treeNode);
        CausalBehaviouralProfile<NetSystem, Node> cbp = CBPCreatorNet.getInstance().deriveCausalBehaviouralProfile(bp);
        this.bp2nodemapping.put(cbp, this.bp2nodemapping.get(bp));
        return cbp;
    }

    private boolean areCooccurringUType(Node t1, Node t2, IRPSTNode<Flow, Node> fragment) {
        if (!this.node2cbp.containsKey(fragment)) {
            this.node2cbp.put(fragment, this.getCBPForFragment(fragment));
        }
        CausalBehaviouralProfile<NetSystem, Node> cbp = this.node2cbp.get(fragment);
        return cbp.areCooccurring(this.bp2nodemapping.get(cbp).get(t1), this.bp2nodemapping.get(cbp).get(t2));
    }

    public RelSetType getRelationForNodes(Node t1, Node t2) {
        if (this.areExclusive(t1, t2)) {
            return RelSetType.Exclusive;
        }
        if (this.areInterleaving(t1, t2)) {
            return RelSetType.Interleaving;
        }
        if (this.areInStrictOrder(t1, t2)) {
            return RelSetType.Order;
        }
        if (this.areInStrictOrder(t2, t1)) {
            return RelSetType.ReverseOrder;
        }
        return RelSetType.None;
    }
}

