/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.sim;

import org.jbpt.alignment.Alignment;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.sim.AbstractRelSetSimilarity;
import org.jbpt.bp.sim.ExclusivenessSimilarity;
import org.jbpt.bp.sim.ExtendedInterleavingSimilarity;
import org.jbpt.bp.sim.ExtendedOrderSimilarity;
import org.jbpt.bp.sim.InterleavingSimilarity;
import org.jbpt.bp.sim.OrderSimilarity;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;

public class AggregatedSimilarity<R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity>
extends AbstractRelSetSimilarity<R, M, N> {
    public double weightExSim = 0.0;
    public double weightSoSim = 0.0;
    public double weightInSim = 0.0;
    public double weightESSim = 0.0;
    public double weightEISim = 0.0;
    private ExclusivenessSimilarity<R, M, N> ex = new ExclusivenessSimilarity();
    private OrderSimilarity<R, M, N> so = new OrderSimilarity();
    private InterleavingSimilarity<R, M, N> in = new InterleavingSimilarity();
    private ExtendedOrderSimilarity<R, M, N> eso = new ExtendedOrderSimilarity();
    private ExtendedInterleavingSimilarity<R, M, N> ein = new ExtendedInterleavingSimilarity();

    @Override
    public double score(Alignment<R, N> alignment) {
        double weightSum = this.weightExSim + this.weightSoSim + this.weightInSim + this.weightESSim + this.weightEISim;
        return (this.weightExSim > 0.0 ? this.weightExSim / weightSum * this.ex.score(alignment) : 0.0) + (this.weightSoSim > 0.0 ? this.weightSoSim / weightSum * this.so.score(alignment) : 0.0) + (this.weightInSim > 0.0 ? this.weightInSim / weightSum * this.in.score(alignment) : 0.0) + (this.weightESSim > 0.0 ? this.weightESSim / weightSum * this.eso.score(alignment) : 0.0) + (this.weightEISim > 0.0 ? this.weightEISim / weightSum * this.ein.score(alignment) : 0.0);
    }

    @Override
    public double scoreDice(Alignment<R, N> alignment) {
        double weightSum = this.weightExSim + this.weightSoSim + this.weightInSim + this.weightESSim + this.weightEISim;
        return (this.weightExSim > 0.0 ? this.weightExSim / weightSum * this.ex.scoreDice(alignment) : 0.0) + (this.weightSoSim > 0.0 ? this.weightSoSim / weightSum * this.so.scoreDice(alignment) : 0.0) + (this.weightInSim > 0.0 ? this.weightInSim / weightSum * this.in.scoreDice(alignment) : 0.0) + (this.weightESSim > 0.0 ? this.weightESSim / weightSum * this.eso.scoreDice(alignment) : 0.0) + (this.weightEISim > 0.0 ? this.weightEISim / weightSum * this.ein.scoreDice(alignment) : 0.0);
    }

    @Override
    public String getName() {
        return String.valueOf(this.getClass().getName()) + "Ex:" + this.weightExSim + "-" + "So:" + this.weightSoSim + "-" + "In:" + this.weightInSim + "-" + "ES:" + this.weightESSim + "-" + "EI:" + this.weightEISim + "-";
    }

    public void setWeights(double weightExSim, double weightSoSim, double weightInSim, double weightESSim, double weightEISim) {
        this.weightExSim = weightExSim;
        this.weightSoSim = weightSoSim;
        this.weightInSim = weightInSim;
        this.weightESSim = weightESSim;
        this.weightEISim = weightEISim;
    }
}

