/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.sim;

import org.jbpt.alignment.Alignment;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.sim.AbstractRelSetSimilarity;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;

public class BaselineSimilarity<R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity>
extends AbstractRelSetSimilarity<R, M, N> {
    @Override
    public double score(Alignment<R, N> alignment) {
        double in1 = 0.0;
        for (IEntity n : ((RelSet)alignment.getFirstModel()).getEntities()) {
            if (n instanceof Place || ((Transition)n).isSilent()) continue;
            in1 += 1.0;
        }
        double in2 = 0.0;
        for (IEntity n : ((RelSet)alignment.getSecondModel()).getEntities()) {
            if (n instanceof Place || ((Transition)n).isSilent()) continue;
            in2 += 1.0;
        }
        double intersection = alignment.getAlignedEntitiesOfFirstModel().size();
        return intersection > 0.0 ? intersection / (in1 + in2 - intersection) : 0.0;
    }

    @Override
    public double scoreDice(Alignment<R, N> alignment) {
        double in1 = 0.0;
        for (IEntity n : ((RelSet)alignment.getFirstModel()).getEntities()) {
            if (n instanceof Place || ((Transition)n).isSilent()) continue;
            in1 += 1.0;
        }
        double in2 = 0.0;
        for (IEntity n : ((RelSet)alignment.getSecondModel()).getEntities()) {
            if (n instanceof Place || ((Transition)n).isSilent()) continue;
            in2 += 1.0;
        }
        double intersection = alignment.getAlignedEntitiesOfFirstModel().size();
        return in1 + in2 > 0.0 ? 2.0 * intersection / (in1 + in2) : 0.0;
    }
}

