/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.sim;

import org.jbpt.alignment.Alignment;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.sim.AbstractRelSetSimilarity;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;

public class OrderSimilarity<R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity>
extends AbstractRelSetSimilarity<R, M, N> {
    @Override
    public double score(Alignment<R, N> alignment) {
        double in1 = super.getSizeOfRelation((RelSet)alignment.getFirstModel(), RelSetType.Order);
        double in2 = super.getSizeOfRelation((RelSet)alignment.getSecondModel(), RelSetType.Order);
        double intersection = super.getSizeOfIntersectionOfRelation(alignment, RelSetType.Order);
        return intersection > 0.0 ? intersection / (in1 + in2 - intersection) : 0.0;
    }

    @Override
    public double scoreDice(Alignment<R, N> alignment) {
        double in1 = super.getSizeOfRelation((RelSet)alignment.getFirstModel(), RelSetType.Order);
        double in2 = super.getSizeOfRelation((RelSet)alignment.getSecondModel(), RelSetType.Order);
        double intersection = super.getSizeOfIntersectionOfRelation(alignment, RelSetType.Order);
        return in1 + in2 > 0.0 ? 2.0 * intersection / (in1 + in2) : 0.0;
    }
}

