/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.sim;

import java.util.HashMap;
import java.util.Map;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;

public class RelSetSizeCache {
    private static RelSetSizeCache eInstance;
    private Map<RelSet, Map<RelSetType, Integer>> relationChache = new HashMap<RelSet, Map<RelSetType, Integer>>();

    public static RelSetSizeCache getInstance() {
        if (eInstance == null) {
            eInstance = new RelSetSizeCache();
        }
        return eInstance;
    }

    private RelSetSizeCache() {
    }

    public void invalidateCache() {
        this.relationChache = new HashMap<RelSet, Map<RelSetType, Integer>>();
    }

    public boolean containsEntry(RelSet rs, RelSetType type) {
        if (!this.relationChache.containsKey(rs)) {
            return false;
        }
        return this.relationChache.get(rs).containsKey((Object)type);
    }

    public void addEntry(RelSet rs, RelSetType type, int size) {
        if (!this.relationChache.containsKey(rs)) {
            this.relationChache.put(rs, new HashMap());
        }
        this.relationChache.get(rs).put(type, size);
    }

    public int getRelationSize(RelSet rs, RelSetType type) {
        if (!this.containsEntry(rs, type)) {
            return -1;
        }
        return this.relationChache.get(rs).get((Object)type);
    }
}

