/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.conform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpt.alignment.LabelEntity;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.CausalBehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.conform.ConformanceRootCauseAnalysis;
import org.jbpt.petri.log.Trace;
import org.jbpt.utils.IOUtils;

public class ConformanceAnalysis {
    protected static Set<String> IGNORED_LABEL_SUBSTRINGS = new HashSet<String>();
    protected Set<TraceAnalysisTask> traceAnalysisTasks = new HashSet<TraceAnalysisTask>();
    protected CausalBehaviouralProfile<NetSystem, LabelEntity> baseProfile;
    protected ConformanceRootCauseAnalysis rootCauseAnalysis = new ConformanceRootCauseAnalysis();

    public ConformanceAnalysis(CausalBehaviouralProfile<NetSystem, LabelEntity> profile) {
        this.baseProfile = profile;
    }

    public void addTrace(BehaviouralProfile<Trace, LabelEntity> traceProfile) {
        TraceAnalysisTask task = new TraceAnalysisTask(traceProfile);
        this.traceAnalysisTasks.add(task);
        this.rootCauseAnalysis.addTrace(traceProfile);
    }

    public void computeBPConformance() {
        for (TraceAnalysisTask p : this.traceAnalysisTasks) {
            this.computeBPConformance(p);
        }
    }

    protected boolean firstCompatibleWithSecondAsSelfRelation(RelSetType rel1, RelSetType rel2) {
        if (rel1.equals((Object)rel2)) {
            return true;
        }
        return rel1.equals((Object)RelSetType.Interleaving);
    }

    protected boolean firstCompatibleWithSecond(RelSetType rel1, RelSetType rel2) {
        if (rel1.equals((Object)rel2)) {
            return true;
        }
        if (rel1.equals((Object)RelSetType.Interleaving)) {
            return true;
        }
        if (rel1.equals((Object)RelSetType.Order) && rel2.equals((Object)RelSetType.Exclusive)) {
            return true;
        }
        return rel1.equals((Object)RelSetType.ReverseOrder) && rel2.equals((Object)RelSetType.Exclusive);
    }

    protected void computeBPConformance(TraceAnalysisTask pair) {
        float consistentPairs = 0.0f;
        float consistentNonInterleavingPairs = 0.0f;
        float nonInterleavingPairs = 0.0f;
        try {
            BehaviouralProfile<Trace, LabelEntity> traceProfile = pair.getTraceProfile();
            int i = 0;
            while (i < pair.getTraceLabelsAsList().size()) {
                int j = i;
                while (j < pair.getTraceLabelsAsList().size()) {
                    boolean checkResult;
                    String label1 = pair.getTraceLabelsAsList().get(i);
                    String label2 = pair.getTraceLabelsAsList().get(j);
                    RelSetType rel1 = this.baseProfile.getRelationForEntities(new LabelEntity(label1), new LabelEntity(label2));
                    RelSetType rel2 = traceProfile.getRelationForEntities(new LabelEntity(label1), new LabelEntity(label2));
                    if (i == j) {
                        if (!rel1.equals((Object)RelSetType.Interleaving)) {
                            nonInterleavingPairs += 1.0f;
                        }
                        if (checkResult = this.firstCompatibleWithSecondAsSelfRelation(rel1, rel2)) {
                            consistentPairs += 1.0f;
                        } else {
                            this.rootCauseAnalysis.addBPViolation(label1, label2, pair.getTraceProfile(), rel1, rel2);
                        }
                        if (checkResult && !rel1.equals((Object)RelSetType.Interleaving)) {
                            consistentNonInterleavingPairs += 1.0f;
                        }
                    } else {
                        if (!rel1.equals((Object)RelSetType.Interleaving)) {
                            nonInterleavingPairs += 2.0f;
                        }
                        if (checkResult = this.firstCompatibleWithSecond(rel1, rel2)) {
                            consistentPairs += 2.0f;
                        } else {
                            this.rootCauseAnalysis.addBPViolation(label1, label2, pair.getTraceProfile(), rel1, rel2);
                            this.rootCauseAnalysis.addBPViolation(label2, label1, pair.getTraceProfile(), BehaviouralProfile.getComplementRelation(rel1), BehaviouralProfile.getComplementRelation(rel2));
                        }
                        if (checkResult && !rel1.equals((Object)RelSetType.Interleaving)) {
                            consistentNonInterleavingPairs += 2.0f;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            float countPairs = pair.getTraceLabelsAsList().size() * pair.getTraceLabelsAsList().size();
            pair.setModelRelativeBehaviouralProfileConformanceTop(consistentPairs);
            pair.setModelRelativeBehaviouralProfileConformanceBottom(countPairs);
            pair.setConstraintRelativeBehaviouralProfileConformanceTop(consistentNonInterleavingPairs);
            pair.setConstraintRelativeBehaviouralProfileConformanceBottom(nonInterleavingPairs);
            pair.setModelRelativeBehaviouralProfileConformance(consistentPairs / countPairs);
            pair.setConstraintRelativeBehaviouralProfileConformance(consistentNonInterleavingPairs / nonInterleavingPairs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveResults(String fileName) {
        String[] captions = new String[]{"Trace ID", "Number of Matched Tasks", "Constraint-Rel BP Conformance", "Model-Rel BP Conformance", "Constraint-Rel Co-occurrence Conformance", "Model-Rel Co-occurrence Conformance", "Constraint-Rel Overall Conformance", "Model-Rel Overall Conformance"};
        HashSet<String[]> rows = new HashSet<String[]>();
        for (TraceAnalysisTask pair : this.traceAnalysisTasks) {
            String[] row = new String[]{String.valueOf(((Trace)pair.getTraceProfile().getModel()).getId()), String.valueOf(pair.getTraceLabelsAsList().size()), String.valueOf(pair.getConstraintRelativeBehaviouralProfileConformance()), String.valueOf(pair.getModelRelativeBehaviouralProfileConformance()), String.valueOf(pair.getConstraintRelativeCooccurrenceConformance()), String.valueOf(pair.getModelRelativeCooccurrenceConformance()), String.valueOf(pair.getConstraintRelativeConformance()), String.valueOf(pair.getModelRelativeConformance())};
            rows.add(row);
        }
        IOUtils.writeResultsToFile((String)fileName, (String[])captions, rows);
        this.rootCauseAnalysis.computeGlobalSupport();
        this.rootCauseAnalysis.computeConfidenceForViolationPairs();
        this.rootCauseAnalysis.saveResults(fileName);
    }

    private boolean isExpected(List<String> trace, String expectedTraceTask) {
        for (String traceTask1 : trace) {
            for (String traceTask2 : trace) {
                if (traceTask1 == expectedTraceTask || traceTask2 == expectedTraceTask) continue;
                RelSetType relExpTrace2 = this.baseProfile.getRelationForEntities(new LabelEntity(expectedTraceTask), new LabelEntity(traceTask2));
                RelSetType relObs1Trace2 = this.baseProfile.getRelationForEntities(new LabelEntity(traceTask1), new LabelEntity(traceTask2));
                if (!relExpTrace2.equals((Object)RelSetType.Order) || !this.baseProfile.areCooccurring(new LabelEntity(traceTask1), new LabelEntity(expectedTraceTask)) || !traceTask1.equals(traceTask2) && !relObs1Trace2.equals((Object)RelSetType.Order)) continue;
                return true;
            }
        }
        return false;
    }

    public void computeCooccurrenceConformance() {
        for (TraceAnalysisTask p : this.traceAnalysisTasks) {
            BehaviouralProfile<Trace, LabelEntity> traceProfile = p.getTraceProfile();
            HashSet<String> eA = new HashSet<String>();
            for (LabelEntity e : this.baseProfile.getEntities()) {
                if (IGNORED_LABEL_SUBSTRINGS.contains(e.getLabel()) || !traceProfile.getEntities().contains(e) && !this.isExpected(p.getTraceLabelsAsList(), e.getLabel())) continue;
                eA.add(e.getLabel());
            }
            int topConstraintRel = 0;
            int topModelRel = 0;
            int bottomConstraintRel = 0;
            int bottomModelRel = eA.size() * eA.size() - eA.size();
            for (String s1 : eA) {
                for (String s2 : eA) {
                    if (s1.equals(s2) || IGNORED_LABEL_SUBSTRINGS.contains(s1) || IGNORED_LABEL_SUBSTRINGS.contains(s2)) continue;
                    if (this.baseProfile.areCooccurring(new LabelEntity(s1), new LabelEntity(s2))) {
                        ++bottomConstraintRel;
                        if (traceProfile.getEntities().contains(new LabelEntity(s2))) {
                            ++topConstraintRel;
                            ++topModelRel;
                            continue;
                        }
                        this.rootCauseAnalysis.addCooccurrenceViolation(s1, s2, traceProfile);
                        continue;
                    }
                    ++topModelRel;
                }
            }
            p.setModelRelativeCooccurrenceConformanceTop(topModelRel);
            p.setModelRelativeCooccurrenceConformanceBottom(bottomModelRel);
            p.setConstraintRelativeCooccurrenceConformanceTop(topConstraintRel);
            p.setConstraintRelativeCooccurrenceConformanceBottom(bottomConstraintRel);
            p.setModelRelativeCooccurrenceConformance((float)topModelRel / (float)bottomModelRel);
            if (bottomConstraintRel == 0) {
                p.setConstraintRelativeCooccurrenceConformance(1.0f);
                continue;
            }
            p.setConstraintRelativeCooccurrenceConformance((float)topConstraintRel / (float)bottomConstraintRel);
        }
    }

    public void computeOverallConformance() {
        for (TraceAnalysisTask p : this.traceAnalysisTasks) {
            float constraintRelativeConformance = (p.getConstraintRelativeBehaviouralProfileConformanceTop() + p.getConstraintRelativeCooccurrenceConformanceTop()) / (p.getConstraintRelativeBehaviouralProfileConformanceBottom() + p.getConstraintRelativeCooccurrenceConformanceBottom());
            float modelRelativeConformance = (p.getModelRelativeBehaviouralProfileConformanceTop() + p.getModelRelativeCooccurrenceConformanceTop()) / (p.getModelRelativeBehaviouralProfileConformanceBottom() + p.getModelRelativeCooccurrenceConformanceBottom());
            p.setConstraintRelativeConformance(constraintRelativeConformance);
            p.setModelRelativeConformance(modelRelativeConformance);
        }
    }

    public Set<TraceAnalysisTask> getAnalysisTasks() {
        return this.traceAnalysisTasks;
    }

    public class TraceAnalysisTask {
        protected BehaviouralProfile<Trace, LabelEntity> traceProfile;
        protected float constraintRelativeBehaviouralProfileConformance = -1.0f;
        protected float modelRelativeBehaviouralProfileConformance = -1.0f;
        protected float constraintRelativeBehaviouralProfileConformanceTop = -1.0f;
        protected float constraintRelativeBehaviouralProfileConformanceBottom = -1.0f;
        protected float modelRelativeBehaviouralProfileConformanceTop = -1.0f;
        protected float modelRelativeBehaviouralProfileConformanceBottom = -1.0f;
        protected float constraintRelativeCooccurrenceConformance = -1.0f;
        protected float modelRelativeCooccurrenceConformance = -1.0f;
        protected float constraintRelativeOverallConformance = -1.0f;
        protected float modelRelativeOverallConformance = -1.0f;
        protected float constraintRelativeCooccurrenceConformanceTop = -1.0f;
        protected float constraintRelativeCooccurrenceConformanceBottom = -1.0f;
        protected float modelRelativeCooccurrenceConformanceTop = -1.0f;
        protected float modelRelativeCooccurrenceConformanceBottom = -1.0f;
        protected List<String> traceLabelsAsList = new ArrayList<String>();

        public TraceAnalysisTask(BehaviouralProfile<Trace, LabelEntity> traceProfile) {
            this.traceProfile = traceProfile;
            for (String s : ((Trace)this.traceProfile.getModel()).getLabelsOfTrace()) {
                if (s.equals("") || !ConformanceAnalysis.this.baseProfile.getEntities().contains(new LabelEntity(s))) continue;
                this.traceLabelsAsList.add(s);
            }
        }

        public List<String> getTraceLabelsAsList() {
            return this.traceLabelsAsList;
        }

        public BehaviouralProfile<Trace, LabelEntity> getTraceProfile() {
            return this.traceProfile;
        }

        public void setTraceProfile(BehaviouralProfile<Trace, LabelEntity> traceProfile) {
            this.traceProfile = traceProfile;
        }

        public float getConstraintRelativeCooccurrenceConformance() {
            return this.constraintRelativeCooccurrenceConformance;
        }

        public void setConstraintRelativeCooccurrenceConformance(float constraintRelativeCooccurrenceConformance) {
            this.constraintRelativeCooccurrenceConformance = constraintRelativeCooccurrenceConformance;
        }

        public float getModelRelativeCooccurrenceConformance() {
            return this.modelRelativeCooccurrenceConformance;
        }

        public void setModelRelativeCooccurrenceConformance(float modelRelativeCooccurrenceConformance) {
            this.modelRelativeCooccurrenceConformance = modelRelativeCooccurrenceConformance;
        }

        public float getConstraintRelativeConformance() {
            return this.constraintRelativeOverallConformance;
        }

        public void setConstraintRelativeConformance(float constraintRelativeConformance) {
            this.constraintRelativeOverallConformance = constraintRelativeConformance;
        }

        public float getModelRelativeConformance() {
            return this.modelRelativeOverallConformance;
        }

        public void setModelRelativeConformance(float modelRelativeConformance) {
            this.modelRelativeOverallConformance = modelRelativeConformance;
        }

        public float getConstraintRelativeCooccurrenceConformanceTop() {
            return this.constraintRelativeCooccurrenceConformanceTop;
        }

        public void setConstraintRelativeCooccurrenceConformanceTop(float constraintRelativeCooccurrenceConformanceTop) {
            this.constraintRelativeCooccurrenceConformanceTop = constraintRelativeCooccurrenceConformanceTop;
        }

        public float getConstraintRelativeCooccurrenceConformanceBottom() {
            return this.constraintRelativeCooccurrenceConformanceBottom;
        }

        public void setConstraintRelativeCooccurrenceConformanceBottom(float constraintRelativeCooccurrenceConformanceBottom) {
            this.constraintRelativeCooccurrenceConformanceBottom = constraintRelativeCooccurrenceConformanceBottom;
        }

        public float getModelRelativeCooccurrenceConformanceTop() {
            return this.modelRelativeCooccurrenceConformanceTop;
        }

        public void setModelRelativeCooccurrenceConformanceTop(float modelRelativeCooccurrenceConformanceTop) {
            this.modelRelativeCooccurrenceConformanceTop = modelRelativeCooccurrenceConformanceTop;
        }

        public float getModelRelativeCooccurrenceConformanceBottom() {
            return this.modelRelativeCooccurrenceConformanceBottom;
        }

        public void setModelRelativeCooccurrenceConformanceBottom(float modelRelativeCooccurrenceConformanceBottom) {
            this.modelRelativeCooccurrenceConformanceBottom = modelRelativeCooccurrenceConformanceBottom;
        }

        public float getConstraintRelativeBehaviouralProfileConformance() {
            return this.constraintRelativeBehaviouralProfileConformance;
        }

        public void setConstraintRelativeBehaviouralProfileConformance(float constraintRelativeBehaviouralProfileConformance) {
            this.constraintRelativeBehaviouralProfileConformance = constraintRelativeBehaviouralProfileConformance;
        }

        public float getModelRelativeBehaviouralProfileConformance() {
            return this.modelRelativeBehaviouralProfileConformance;
        }

        public void setModelRelativeBehaviouralProfileConformance(float modelRelativeBehaviouralProfileConformance) {
            this.modelRelativeBehaviouralProfileConformance = modelRelativeBehaviouralProfileConformance;
        }

        public float getConstraintRelativeBehaviouralProfileConformanceTop() {
            return this.constraintRelativeBehaviouralProfileConformanceTop;
        }

        public void setConstraintRelativeBehaviouralProfileConformanceTop(float constraintRelativeBehaviouralProfileConformanceTop) {
            this.constraintRelativeBehaviouralProfileConformanceTop = constraintRelativeBehaviouralProfileConformanceTop;
        }

        public float getConstraintRelativeBehaviouralProfileConformanceBottom() {
            return this.constraintRelativeBehaviouralProfileConformanceBottom;
        }

        public void setConstraintRelativeBehaviouralProfileConformanceBottom(float constraintRelativeBehaviouralProfileConformanceBottom) {
            this.constraintRelativeBehaviouralProfileConformanceBottom = constraintRelativeBehaviouralProfileConformanceBottom;
        }

        public float getModelRelativeBehaviouralProfileConformanceTop() {
            return this.modelRelativeBehaviouralProfileConformanceTop;
        }

        public void setModelRelativeBehaviouralProfileConformanceTop(float modelRelativeBehaviouralProfileConformanceTop) {
            this.modelRelativeBehaviouralProfileConformanceTop = modelRelativeBehaviouralProfileConformanceTop;
        }

        public float getModelRelativeBehaviouralProfileConformanceBottom() {
            return this.modelRelativeBehaviouralProfileConformanceBottom;
        }

        public void setModelRelativeBehaviouralProfileConformanceBottom(float modelRelativeBehaviouralProfileConformanceBottom) {
            this.modelRelativeBehaviouralProfileConformanceBottom = modelRelativeBehaviouralProfileConformanceBottom;
        }
    }
}

