/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.log;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.hypergraph.abs.IEntityModel;
import org.jbpt.petri.log.Trace;
import org.jbpt.petri.log.TraceEntry;

public class Log
implements IEntityModel<TraceEntry> {
    protected int id;
    protected Map<Trace, Integer> traces = new HashMap<Trace, Integer>();
    protected Set<String> labels = new HashSet<String>();
    protected Set<TraceEntry> traceEntries = new HashSet<TraceEntry>();
    protected int lengthLongestTrace = 0;

    public void addTrace(Trace trace) {
        boolean found = false;
        for (Trace trace2 : this.traces.keySet()) {
            if (!this.tracesShowSameSequenceOfLabels(trace2, trace)) continue;
            this.traces.put(trace2, this.traces.get(trace2) + 1);
            found = true;
            break;
        }
        if (!found) {
            this.traces.put(trace, 1);
            this.labels.addAll(trace.getLabelsOfTrace());
            this.lengthLongestTrace = Math.max(this.lengthLongestTrace, trace.getLength());
        }
        for (TraceEntry traceEntry : trace.getTraceAsList()) {
            this.traceEntries.add(traceEntry);
        }
    }

    public Collection<String> getLabelsOfLog() {
        return this.labels;
    }

    public Collection<Trace> getTraces() {
        return this.traces.keySet();
    }

    public int getLengthLongestTrace() {
        return this.lengthLongestTrace;
    }

    public Collection<TraceEntry> getEntities() {
        return this.traceEntries;
    }

    protected boolean tracesShowSameSequenceOfLabels(Trace t1, Trace t2) {
        if (t1.getLength() != t2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < t1.getTraceAsList().size()) {
            if (!t1.getTraceAsList().get(i).getLabel().equals(t2.getTraceAsList().get(i).getLabel())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

