/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpt.hypergraph.abs.IEntityModel;
import org.jbpt.petri.log.TraceEntry;

public class Trace
implements IEntityModel<TraceEntry> {
    protected String id;
    protected List<TraceEntry> trace;
    protected Set<String> labels;

    public Trace(List<TraceEntry> trace) {
        this.trace = trace;
        this.labels = new HashSet<String>();
        for (TraceEntry t : trace) {
            this.labels.add(t.getLabel());
        }
    }

    public Trace(String[] trace) {
        this.labels = new HashSet<String>();
        this.trace = new ArrayList<TraceEntry>();
        int i = 0;
        while (i < trace.length) {
            this.trace.add(new TraceEntry(trace[i]));
            this.labels.add(trace[i]);
            ++i;
        }
    }

    public List<TraceEntry> getTraceAsList() {
        return this.trace;
    }

    public Collection<TraceEntry> getEntities() {
        return this.trace;
    }

    public Set<String> getLabelsOfTrace() {
        return this.labels;
    }

    public int getLength() {
        return this.trace.size();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

