/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpt.bp.RelSetType;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelSet<M, N extends IEntity>
implements IEntityModel<N> {
    public static final int RELATION_FAR_LOOKAHEAD = 100000;
    protected int lookAhead = 100000;
    protected M model;
    protected List<N> entities;
    protected RelSetType[][] matrix;

    public static RelSetType getReverseRelation(RelSetType rel) {
        if (rel.equals((Object)RelSetType.Order)) {
            return RelSetType.ReverseOrder;
        }
        if (rel.equals((Object)RelSetType.ReverseOrder)) {
            return RelSetType.Order;
        }
        return rel;
    }

    public static RelSetType getComplementRelation(RelSetType rel) {
        if (rel.equals((Object)RelSetType.Order)) {
            return RelSetType.ReverseOrder;
        }
        if (rel.equals((Object)RelSetType.ReverseOrder)) {
            return RelSetType.Order;
        }
        if (rel.equals((Object)RelSetType.Interleaving)) {
            return RelSetType.Exclusive;
        }
        return RelSetType.Interleaving;
    }

    public RelSetType[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(RelSetType[][] matrix) {
        this.matrix = matrix;
    }

    public List<N> getEntities() {
        return this.entities;
    }

    public M getModel() {
        return this.model;
    }

    public int getLookAhead() {
        return this.lookAhead;
    }

    public void setLookAhead(int lookAhead) {
        this.lookAhead = lookAhead;
    }

    public static String getSymbolForRelation(RelSetType rel) {
        return rel.toString();
    }

    public RelSet(M model, List<N> entities) {
        this.model = model;
        this.entities = entities;
        this.matrix = new RelSetType[this.entities.size()][this.entities.size()];
    }

    public RelSet(M model, Collection<N> entities) {
        this(model, (List<N>)new ArrayList<N>(entities));
    }

    public RelSet(M model, Collection<N> entities, int lookAhead) {
        this(model, (List<N>)new ArrayList<N>(entities));
        this.lookAhead = lookAhead;
    }

    public RelSet(int size) {
        this.matrix = new RelSetType[size][size];
    }

    public boolean areInterleaving(N n1, N n2) {
        int index1 = this.entities.indexOf(n1);
        int index2 = this.entities.indexOf(n2);
        if (index1 == -1 || index2 == -1) {
            throw new InvalidParameterException("The structure is not defined for the respective entities.");
        }
        return this.matrix[index1][index2].equals((Object)RelSetType.Interleaving);
    }

    public boolean areExclusive(N n1, N n2) {
        int index1 = this.entities.indexOf(n1);
        int index2 = this.entities.indexOf(n2);
        if (index1 == -1 || index2 == -1) {
            throw new InvalidParameterException("The structure is not defined for the respective entities.");
        }
        return this.matrix[index1][index2].equals((Object)RelSetType.Exclusive);
    }

    public boolean areInOrder(N n1, N n2) {
        int index1 = this.entities.indexOf(n1);
        int index2 = this.entities.indexOf(n2);
        if (index1 == -1 || index2 == -1) {
            throw new InvalidParameterException("The structure is not defined for the respective entities.");
        }
        return this.matrix[index1][index2].equals((Object)RelSetType.Order);
    }

    public RelSetType getRelationForEntities(N n1, N n2) {
        int index1 = this.entities.indexOf(n1);
        int index2 = this.entities.indexOf(n2);
        if (index1 == -1 || index2 == -1) {
            throw new InvalidParameterException("The structure is not defined for the respective entities.");
        }
        return this.matrix[index1][index2];
    }

    public RelSetType getRelationForIndex(int index1, int index2) {
        return this.matrix[index1][index2];
    }

    public Collection<N> getEntitiesInRelation(N n, RelSetType relationType) {
        ArrayList<N> entities = new ArrayList<N>();
        int index = this.entities.indexOf(n);
        for (int i = 0; i < this.matrix.length; ++i) {
            if (!this.matrix[index][i].equals((Object)relationType)) continue;
            entities.add(this.entities.get(i));
        }
        return entities;
    }

    public void printAllEntities(RelSetType relationType) {
        for (IEntity n1 : this.entities) {
            int index1 = this.entities.indexOf(n1);
            for (IEntity n2 : this.entities) {
                int index2 = this.entities.indexOf(n2);
                if (index2 > index1 || !this.matrix[index1][index2].equals((Object)relationType)) continue;
                System.out.println((Object)((Object)relationType) + " -- " + n1 + " : " + n2);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------------------------------------------\n");
        sb.append("Relation Set Matrix (Lookahead: " + this.lookAhead + ") \n");
        sb.append("------------------------------------------------------\n");
        for (int k = 0; k < this.matrix.length; ++k) {
            for (int row = 0; row < this.matrix.length; ++row) {
                sb.append((Object)((Object)this.matrix[row][k]) + " , ");
            }
            sb.append("\n");
        }
        sb.append("------------------------------------------------------\n");
        return sb.toString();
    }

    public boolean equals(RelSet<M, N> relationSet) {
        if (!this.model.equals(relationSet.getModel())) {
            return false;
        }
        if (!this.getEntities().containsAll(relationSet.getEntities()) || !relationSet.getEntities().containsAll(this.getEntities())) {
            return false;
        }
        boolean equal = true;
        for (IEntity n1 : this.entities) {
            for (IEntity n2 : this.entities) {
                if (equal &= this.getRelationForEntities(n1, n2).equals((Object)relationSet.getRelationForEntities(n1, n2))) continue;
                return equal;
            }
        }
        return equal;
    }

    public boolean equalsForSharedEntities(RelSet<M, N> relationSet) {
        if (!this.model.equals(relationSet.getModel())) {
            return false;
        }
        boolean equal = true;
        HashSet sharedEntities = new HashSet(this.getEntities());
        sharedEntities.retainAll(relationSet.getEntities());
        for (IEntity n1 : sharedEntities) {
            for (IEntity n2 : sharedEntities) {
                if (equal &= this.getRelationForEntities(n1, n2).equals((Object)relationSet.getRelationForEntities(n1, n2))) continue;
                return equal;
            }
        }
        return equal;
    }

    public boolean isEmpty() {
        for (IEntity n1 : this.getEntities()) {
            for (IEntity n2 : this.getEntities()) {
                if (this.getRelationForEntities(n1, n2).equals((Object)RelSetType.Exclusive)) continue;
                return false;
            }
        }
        return true;
    }

    public RelSet<M, N> getComplement() {
        RelSet<M, N> cProfile = new RelSet<M, N>(this.getModel(), this.getEntities());
        RelSetType[][] cMatrix = cProfile.getMatrix();
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                cMatrix[i][j] = RelSet.getComplementRelation(this.matrix[i][j]);
            }
        }
        return cProfile;
    }

    public HashMap<RelSetType, HashSet<String>> getRelationsByType(Set<RelSetType> relationTypes) {
        HashMap<RelSetType, HashSet<String>> relations = new HashMap<RelSetType, HashSet<String>>();
        for (RelSetType relationType : relationTypes) {
            relations.put(relationType, new HashSet());
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                relations.get((Object)this.matrix[i][j]).add(this.entities.get(i) + ";" + this.entities.get(j));
            }
        }
        return relations;
    }
}

