/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp;

import java.util.ArrayList;
import org.jbpt.alignment.Alignment;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelSetAlgebra {
    public static <R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity> boolean isEqual(Alignment<R, N> alignment) throws IllegalArgumentException {
        if (alignment.isOverlapping() || !alignment.isFunctional() || !alignment.isInjective()) {
            throw new IllegalArgumentException("Alignment does not satisfy assumptions of set algebra.");
        }
        for (IEntity v1 : alignment.getAlignedEntitiesOfFirstModel()) {
            for (IEntity v2 : alignment.getAlignedEntitiesOfFirstModel()) {
                RelSetType relation2;
                RelSetType relation1 = ((RelSet)alignment.getFirstModel()).getRelationForEntities(v1, v2);
                if (relation1.equals((Object)(relation2 = ((RelSet)alignment.getSecondModel()).getRelationForEntities((IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v1).iterator().next(), (IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v2).iterator().next())))) continue;
                return false;
            }
        }
        return true;
    }

    public static <R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity> boolean secondSubsumesFirst(Alignment<R, N> alignment) throws IllegalArgumentException {
        if (alignment.isOverlapping() || !alignment.isFunctional() || !alignment.isInjective()) {
            throw new IllegalArgumentException("Alignment does not satisfy assumptions of set algebra.");
        }
        for (IEntity v1 : alignment.getAlignedEntitiesOfSecondModel()) {
            for (IEntity v2 : alignment.getAlignedEntitiesOfSecondModel()) {
                RelSetType relation1 = ((RelSet)alignment.getSecondModel()).getRelationForEntities(v1, v2);
                RelSetType relation2 = ((RelSet)alignment.getFirstModel()).getRelationForEntities((IEntity)alignment.getCorrespondingEntitiesForEntityOfSecondModel(v1).iterator().next(), (IEntity)alignment.getCorrespondingEntitiesForEntityOfSecondModel(v2).iterator().next());
                if (relation1.equals((Object)RelSetType.Exclusive) && !relation2.equals((Object)RelSetType.Exclusive)) {
                    return false;
                }
                if (relation1.equals((Object)RelSetType.Order) && !relation2.equals((Object)RelSetType.Exclusive) && !relation2.equals((Object)RelSetType.Order)) {
                    return false;
                }
                if (!relation1.equals((Object)RelSetType.ReverseOrder) || relation2.equals((Object)RelSetType.Exclusive) || relation2.equals((Object)RelSetType.ReverseOrder)) continue;
                return false;
            }
        }
        return true;
    }

    public static <R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity> boolean firstSubsumesSecond(Alignment<R, N> alignment) throws IllegalArgumentException {
        if (alignment.isOverlapping() || !alignment.isFunctional() || !alignment.isInjective()) {
            throw new IllegalArgumentException("Alignment does not satisfy assumptions of set algebra.");
        }
        for (IEntity v1 : alignment.getAlignedEntitiesOfFirstModel()) {
            for (IEntity v2 : alignment.getAlignedEntitiesOfFirstModel()) {
                RelSetType relation1 = ((RelSet)alignment.getFirstModel()).getRelationForEntities(v1, v2);
                RelSetType relation2 = ((RelSet)alignment.getSecondModel()).getRelationForEntities((IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v1).iterator().next(), (IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v2).iterator().next());
                if (relation1.equals((Object)RelSetType.Exclusive) && !relation2.equals((Object)RelSetType.Exclusive)) {
                    return false;
                }
                if (relation1.equals((Object)RelSetType.Order) && !relation2.equals((Object)RelSetType.Exclusive) && !relation2.equals((Object)RelSetType.Order)) {
                    return false;
                }
                if (!relation1.equals((Object)RelSetType.ReverseOrder) || relation2.equals((Object)RelSetType.Exclusive) || relation2.equals((Object)RelSetType.ReverseOrder)) continue;
                return false;
            }
        }
        return true;
    }

    public static <R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity> void fillIntersection(Alignment<R, N> alignment, R relSet) throws IllegalArgumentException {
        if (alignment.isOverlapping() || !alignment.isFunctional() || !alignment.isInjective()) {
            throw new IllegalArgumentException("Alignment does not satisfy assumptions of set algebra.");
        }
        ArrayList entityList = new ArrayList(alignment.getAlignedEntitiesOfFirstModel());
        RelSetType[][] matrix = relSet.getMatrix();
        for (IEntity v1 : entityList) {
            int index1 = relSet.getEntities().indexOf(v1);
            for (IEntity v2 : entityList) {
                int index2 = relSet.getEntities().indexOf(v2);
                if (index2 > index1) continue;
                RelSetType relation1 = ((RelSet)alignment.getFirstModel()).getRelationForEntities(v1, v2);
                RelSetType relation2 = ((RelSet)alignment.getSecondModel()).getRelationForEntities((IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v1).iterator().next(), (IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v2).iterator().next());
                if (relation1.equals((Object)RelSetType.Exclusive) || relation2.equals((Object)RelSetType.Exclusive) || relation1.equals((Object)RelSetType.Order) && relation2.equals((Object)RelSetType.ReverseOrder) || relation1.equals((Object)RelSetType.ReverseOrder) && relation2.equals((Object)RelSetType.Order)) {
                    matrix[index1][index2] = RelSetType.Exclusive;
                    matrix[index2][index1] = RelSetType.Exclusive;
                    continue;
                }
                if (relation1.equals((Object)RelSetType.Order) && (relation2.equals((Object)RelSetType.Order) || relation2.equals((Object)RelSetType.Interleaving)) || relation2.equals((Object)RelSetType.Order) && (relation1.equals((Object)RelSetType.Order) || relation1.equals((Object)RelSetType.Interleaving))) {
                    matrix[index1][index2] = RelSetType.Order;
                    matrix[index2][index1] = RelSetType.ReverseOrder;
                    continue;
                }
                if (relation1.equals((Object)RelSetType.Interleaving) && relation2.equals((Object)RelSetType.Interleaving)) {
                    matrix[index1][index2] = RelSetType.Interleaving;
                    matrix[index2][index1] = RelSetType.Interleaving;
                    continue;
                }
                matrix[index1][index2] = RelSetType.ReverseOrder;
                matrix[index2][index1] = RelSetType.Order;
            }
        }
    }

    public static <R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity> void fillUnion(Alignment<R, N> alignment, R relSet) throws IllegalArgumentException {
        if (alignment.isOverlapping() || !alignment.isFunctional() || !alignment.isInjective()) {
            throw new IllegalArgumentException("Alignment does not satisfy assumptions of set algebra.");
        }
        ArrayList entityList = new ArrayList(alignment.getAlignedEntitiesOfFirstModel());
        RelSetType[][] matrix = relSet.getMatrix();
        for (IEntity v1 : entityList) {
            int index1 = relSet.getEntities().indexOf(v1);
            for (IEntity v2 : entityList) {
                int index2 = relSet.getEntities().indexOf(v2);
                if (index2 > index1) continue;
                RelSetType relation1 = ((RelSet)alignment.getFirstModel()).getRelationForEntities(v1, v2);
                RelSetType relation2 = ((RelSet)alignment.getSecondModel()).getRelationForEntities((IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v1).iterator().next(), (IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(v2).iterator().next());
                if (relation1.equals((Object)RelSetType.Interleaving) || relation2.equals((Object)RelSetType.Interleaving) || relation1.equals((Object)RelSetType.Order) && relation2.equals((Object)RelSetType.ReverseOrder) || relation1.equals((Object)RelSetType.ReverseOrder) && relation2.equals((Object)RelSetType.Order)) {
                    matrix[index1][index2] = RelSetType.Interleaving;
                    matrix[index2][index1] = RelSetType.Interleaving;
                    continue;
                }
                if (relation1.equals((Object)RelSetType.Order) && (relation2.equals((Object)RelSetType.Order) || relation2.equals((Object)RelSetType.Exclusive)) || relation2.equals((Object)RelSetType.Order) && (relation1.equals((Object)RelSetType.Order) || relation1.equals((Object)RelSetType.Exclusive))) {
                    matrix[index1][index2] = RelSetType.Order;
                    matrix[index2][index1] = RelSetType.ReverseOrder;
                    continue;
                }
                if (relation1.equals((Object)RelSetType.Exclusive) && relation2.equals((Object)RelSetType.Exclusive)) {
                    matrix[index1][index2] = RelSetType.Exclusive;
                    matrix[index2][index1] = RelSetType.Exclusive;
                    continue;
                }
                matrix[index1][index2] = RelSetType.ReverseOrder;
                matrix[index2][index1] = RelSetType.Order;
            }
        }
    }
}

