/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.Transition;
import org.jbpt.petri.unfolding.CompletePrefixUnfolding;
import org.jbpt.petri.unfolding.CompletePrefixUnfoldingSetup;
import org.jbpt.petri.unfolding.Event;
import org.jbpt.petri.unfolding.OccurrenceNet;
import org.jbpt.petri.unfolding.OrderingRelationType;
import org.jbpt.petri.unfolding.order.AdequateOrderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPCreatorUnfolding
extends AbstractRelSetCreator
implements RelSetCreator<NetSystem, Node> {
    private static BPCreatorUnfolding eInstance;
    protected boolean[][] weakOrderMatrixForTransitions;
    protected List<Transition> transitionsForWeakOrderMatrix;
    protected CompletePrefixUnfolding unfolding;
    protected OccurrenceNet occurrenceNet;
    protected boolean[][] transitiveCausalityMatrixUnfolding;
    protected List<Transition> nodesForTransitiveCausalityMatrixUnfolding;

    public static BPCreatorUnfolding getInstance() {
        if (eInstance == null) {
            eInstance = new BPCreatorUnfolding();
        }
        return eInstance;
    }

    private BPCreatorUnfolding() {
    }

    protected void clear() {
        this.unfolding = null;
        this.occurrenceNet = null;
        this.transitiveCausalityMatrixUnfolding = null;
        this.nodesForTransitiveCausalityMatrixUnfolding = new ArrayList<Transition>();
        this.weakOrderMatrixForTransitions = null;
        this.transitionsForWeakOrderMatrix = new ArrayList<Transition>();
    }

    @Override
    public BehaviouralProfile<NetSystem, Node> deriveRelationSet(NetSystem pn) {
        return this.deriveRelationSet(pn, (Collection<Node>)new ArrayList<Node>(pn.getTransitions()));
    }

    @Override
    public BehaviouralProfile<NetSystem, Node> deriveRelationSet(NetSystem pn, Collection<Node> nodes) {
        this.clear();
        CompletePrefixUnfoldingSetup setup = new CompletePrefixUnfoldingSetup();
        setup.ADEQUATE_ORDER = AdequateOrderType.ESPARZA_FOR_ARBITRARY_SYSTEMS;
        this.unfolding = new CompletePrefixUnfolding((INetSystem)pn, setup);
        this.occurrenceNet = (OccurrenceNet)this.unfolding.getOccurrenceNet();
        this.deriveTransitiveCutoffRelation();
        BehaviouralProfile<NetSystem, Node> profile = new BehaviouralProfile<NetSystem, Node>(pn, nodes);
        RelSetType[][] matrix = profile.getMatrix();
        for (Node t : nodes) {
            if (!(t instanceof Transition) || this.transitionsForWeakOrderMatrix.contains((Transition)t)) continue;
            this.transitionsForWeakOrderMatrix.add((Transition)t);
        }
        this.deriveWeakOrderRelation();
        for (Node t1 : profile.getEntities()) {
            int index1 = profile.getEntities().indexOf(t1);
            for (Node t2 : profile.getEntities()) {
                int index2 = profile.getEntities().indexOf(t2);
                if (index2 > index1) continue;
                if (this.isWeakOrder(t1, t2) && this.isWeakOrder(t2, t1)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (this.isWeakOrder(t1, t2)) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                if (this.isWeakOrder(t2, t1)) {
                    super.setMatrixEntryOrder(matrix, index2, index1);
                    continue;
                }
                super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
            }
        }
        return profile;
    }

    protected void deriveWeakOrderRelation() {
        this.weakOrderMatrixForTransitions = new boolean[this.transitionsForWeakOrderMatrix.size()][this.transitionsForWeakOrderMatrix.size()];
        for (Transition e1 : this.occurrenceNet.getTransitions()) {
            for (Transition e2 : this.occurrenceNet.getTransitions()) {
                if (this.occurrenceNet.getOrderingRelation((INode)e1, (INode)e2).equals((Object)OrderingRelationType.CAUSAL) || !e1.equals((Object)e2) && this.occurrenceNet.getOrderingRelation((INode)e1, (INode)e2).equals((Object)OrderingRelationType.CONCURRENT)) {
                    this.weakOrderMatrixForTransitions[this.transitionsForWeakOrderMatrix.indexOf((Object)((Event)this.occurrenceNet.getEvent((ITransition)e1)).getTransition())][this.transitionsForWeakOrderMatrix.indexOf((Object)((Event)this.occurrenceNet.getEvent((ITransition)e2)).getTransition())] = true;
                    continue;
                }
                if (!this.isCausalViaSequenceOfCutOffs(e1, e2)) continue;
                this.weakOrderMatrixForTransitions[this.transitionsForWeakOrderMatrix.indexOf((Object)((Event)this.occurrenceNet.getEvent((ITransition)e1)).getTransition())][this.transitionsForWeakOrderMatrix.indexOf((Object)((Event)this.occurrenceNet.getEvent((ITransition)e2)).getTransition())] = true;
            }
        }
    }

    private boolean isWeakOrder(Node n1, Node n2) {
        return this.weakOrderMatrixForTransitions[this.transitionsForWeakOrderMatrix.indexOf(n1)][this.transitionsForWeakOrderMatrix.indexOf(n2)];
    }

    private void deriveTransitiveCutoffRelation() {
        this.nodesForTransitiveCausalityMatrixUnfolding.addAll(this.occurrenceNet.getCutoffEvents());
        for (Transition t : this.occurrenceNet.getCutoffEvents()) {
            this.nodesForTransitiveCausalityMatrixUnfolding.add((Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)t));
        }
        this.transitiveCausalityMatrixUnfolding = new boolean[this.nodesForTransitiveCausalityMatrixUnfolding.size()][this.nodesForTransitiveCausalityMatrixUnfolding.size()];
        for (Transition eCut : this.occurrenceNet.getCutoffEvents()) {
            int source = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(eCut);
            int target = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(this.occurrenceNet.getCorrespondingEvent((ITransition)eCut));
            this.transitiveCausalityMatrixUnfolding[source][target] = true;
        }
        for (Transition eCut : this.occurrenceNet.getCutoffEvents()) {
            Transition eCor = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)eCut);
            while (this.occurrenceNet.getCutoffEvents().contains(eCor)) {
                eCor = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)eCor);
            }
            for (Transition eCut2 : this.occurrenceNet.getCutoffEvents()) {
                if (!this.occurrenceNet.getOrderingRelation((INode)eCor, (INode)eCut2).equals((Object)OrderingRelationType.CAUSAL)) continue;
                int source = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(eCor);
                int target = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(eCut2);
                this.transitiveCausalityMatrixUnfolding[source][target] = true;
            }
        }
        this.transitiveCausalityMatrixUnfolding = this.computeTransitiveClosure(this.transitiveCausalityMatrixUnfolding);
    }

    private boolean[][] computeTransitiveClosure(boolean[][] matrix) {
        for (int k = 0; k < matrix.length; ++k) {
            for (int row = 0; row < matrix.length; ++row) {
                if (!matrix[row][k]) continue;
                for (int col = 0; col < matrix.length; ++col) {
                    matrix[row][col] = matrix[row][col] | matrix[k][col];
                }
            }
        }
        return matrix;
    }

    private boolean isCausalViaSequenceOfCutOffs(Transition src, Transition tar) {
        for (Transition eCut : this.occurrenceNet.getCutoffEvents()) {
            for (Transition eCut2 : this.occurrenceNet.getCutoffEvents()) {
                Transition eCor = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)eCut2);
                if (!src.equals((Object)eCut) && !this.occurrenceNet.getOrderingRelation((INode)src, (INode)eCut).equals((Object)OrderingRelationType.CAUSAL) || !this.isPathInTransitiveCausalityMatrix(eCut, eCor) || !this.occurrenceNet.getOrderingRelation((INode)eCor, (INode)tar).equals((Object)OrderingRelationType.CAUSAL) && (eCor.equals((Object)tar) || !this.occurrenceNet.getOrderingRelation((INode)eCor, (INode)tar).equals((Object)OrderingRelationType.CONCURRENT))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPathInTransitiveCausalityMatrix(Transition node1, Transition node2) {
        return this.transitiveCausalityMatrixUnfolding[this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(node1)][this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(node2)];
    }
}

