/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.CausalBehaviouralProfile;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.BPCreatorNet;
import org.jbpt.bp.construct.CBPCreator;
import org.jbpt.graph.abs.IDirectedGraph;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.PetriNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBPCreatorNet
extends AbstractRelSetCreator
implements CBPCreator<NetSystem, Node> {
    private static CBPCreatorNet eInstance;

    public static CBPCreatorNet getInstance() {
        if (eInstance == null) {
            eInstance = new CBPCreatorNet();
        }
        return eInstance;
    }

    private CBPCreatorNet() {
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(NetSystem pn) {
        return this.deriveCausalBehaviouralProfile(pn, (Collection<Node>)pn.getNodes());
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(NetSystem pn, Collection<Node> nodes) {
        if (!PetriNet.STRUCTURAL_CHECKS.isWorkflowNet((IPetriNet)pn)) {
            throw new IllegalArgumentException();
        }
        if (!PetriNet.STRUCTURAL_CHECKS.isExtendedFreeChoice((IPetriNet)pn)) {
            throw new IllegalArgumentException();
        }
        if (PetriNet.DIRECTED_GRAPH_ALGORITHMS.isCyclic((IDirectedGraph)pn) && !PetriNet.STRUCTURAL_CHECKS.isTNet((IPetriNet)pn) && !PetriNet.STRUCTURAL_CHECKS.isSNet((IPetriNet)pn)) {
            throw new IllegalArgumentException();
        }
        CausalBehaviouralProfile<NetSystem, Node> profile = new CausalBehaviouralProfile<NetSystem, Node>(pn, nodes);
        profile.setMatrix(BPCreatorNet.getInstance().deriveRelationSet(pn).getMatrix());
        this.fillCooccurrence(pn, profile);
        return profile;
    }

    protected void fillCooccurrence(NetSystem pn, CausalBehaviouralProfile<NetSystem, Node> profile) {
        block9: {
            block10: {
                block8: {
                    if (!PetriNet.STRUCTURAL_CHECKS.isTNet((IPetriNet)pn)) break block8;
                    for (Node n1 : profile.getEntities()) {
                        int index1 = profile.getEntities().indexOf(n1);
                        for (Node n2 : profile.getEntities()) {
                            int index2 = profile.getEntities().indexOf(n2);
                            profile.getCooccurrenceMatrix()[index1][index2] = true;
                        }
                    }
                    break block9;
                }
                if (!PetriNet.STRUCTURAL_CHECKS.isSNet((IPetriNet)pn)) break block10;
                Map dominators = PetriNet.DIRECTED_GRAPH_ALGORITHMS.getDominators((IDirectedGraph)pn, false);
                Map postdominators = PetriNet.DIRECTED_GRAPH_ALGORITHMS.getDominators((IDirectedGraph)pn, true);
                for (Node n1 : profile.getEntities()) {
                    int index1 = profile.getEntities().indexOf(n1);
                    for (Node n2 : profile.getEntities()) {
                        int index2 = profile.getEntities().indexOf(n2);
                        if (!((Set)dominators.get(n1)).contains(n2) && !((Set)postdominators.get(n1)).contains(n2)) continue;
                        profile.getCooccurrenceMatrix()[index1][index2] = true;
                    }
                }
                break block9;
            }
            if (PetriNet.DIRECTED_GRAPH_ALGORITHMS.isCyclic((IDirectedGraph)pn)) break block9;
            for (Node n1 : profile.getEntities()) {
                int index1 = profile.getEntities().indexOf(n1);
                for (Node n2 : profile.getEntities()) {
                    int index2 = profile.getEntities().indexOf(n2);
                    if (index1 == index2) {
                        profile.getCooccurrenceMatrix()[index1][index2] = true;
                    }
                    if (profile.areExclusive(n1, n2)) continue;
                    boolean allExclusive = true;
                    for (Node n3 : profile.getEntitiesInRelation(n2, RelSetType.Exclusive)) {
                        allExclusive &= profile.areExclusive(n1, n3);
                    }
                    if (!allExclusive) continue;
                    profile.getCooccurrenceMatrix()[index1][index2] = true;
                }
            }
        }
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(BehaviouralProfile<NetSystem, Node> bp) {
        NetSystem pn = (NetSystem)bp.getModel();
        CausalBehaviouralProfile<NetSystem, Node> profile = new CausalBehaviouralProfile<NetSystem, Node>(pn, (List<Node>)bp.getEntities());
        profile.setMatrix(bp.getMatrix());
        this.fillCooccurrence(pn, profile);
        return profile;
    }
}

