/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpt.bp.BehaviouralProfile;
import org.jbpt.bp.CausalBehaviouralProfile;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.BPCreatorUnfolding;
import org.jbpt.bp.construct.CBPCreator;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;
import org.jbpt.petri.unfolding.CompletePrefixUnfolding;
import org.jbpt.petri.unfolding.CompletePrefixUnfoldingSetup;
import org.jbpt.petri.unfolding.Condition;
import org.jbpt.petri.unfolding.Event;
import org.jbpt.petri.unfolding.OccurrenceNet;
import org.jbpt.petri.unfolding.OrderingRelationType;
import org.jbpt.petri.unfolding.order.AdequateOrderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBPCreatorUnfolding
extends AbstractRelSetCreator
implements CBPCreator<NetSystem, Node> {
    private static CBPCreatorUnfolding eInstance;
    protected NetSystem augmentedNet;
    protected Map<Node, Node> augmentationFunction;
    protected Map<Transition, Set<Node>> cutOfLocalConfContainsAugmentedPlaceForTransition;
    protected CompletePrefixUnfolding unfolding;
    protected OccurrenceNet occurrenceNet;
    protected boolean[][] eventContinuationMatrix;
    protected List<Transition> transitionsForEventContinutationMatrix;
    protected boolean[][] transitiveCausalityMatrixUnfolding;
    protected List<Transition> nodesForTransitiveCausalityMatrixUnfolding;

    public static CBPCreatorUnfolding getInstance() {
        if (eInstance == null) {
            eInstance = new CBPCreatorUnfolding();
        }
        return eInstance;
    }

    private CBPCreatorUnfolding() {
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(NetSystem pn) {
        return this.deriveCausalBehaviouralProfile(pn, (Collection<Node>)new ArrayList<Node>(pn.getTransitions()));
    }

    protected void clear() {
        this.unfolding = null;
        this.occurrenceNet = null;
        this.augmentedNet = null;
        this.augmentationFunction = new HashMap<Node, Node>();
        this.transitiveCausalityMatrixUnfolding = null;
        this.nodesForTransitiveCausalityMatrixUnfolding = new ArrayList<Transition>();
        this.eventContinuationMatrix = null;
        this.transitionsForEventContinutationMatrix = new ArrayList<Transition>();
        this.cutOfLocalConfContainsAugmentedPlaceForTransition = new HashMap<Transition, Set<Node>>();
    }

    protected CausalBehaviouralProfile<NetSystem, Node> deriveCooccurrence(CausalBehaviouralProfile<NetSystem, Node> profile) {
        NetSystem pn = (NetSystem)profile.getModel();
        boolean[][] cooccurrenceMatrix = profile.getCooccurrenceMatrix();
        this.clear();
        NetSystem netClone = null;
        HashMap<Node, Node> nodeMapping = new HashMap<Node, Node>();
        netClone = (NetSystem)pn.clone(nodeMapping);
        if (netClone == null) {
            netClone = pn;
            for (Node n : pn.getNodes()) {
                nodeMapping.put(n, n);
            }
        }
        this.createAugmentedNet(netClone);
        CompletePrefixUnfoldingSetup setup = new CompletePrefixUnfoldingSetup();
        setup.ADEQUATE_ORDER = AdequateOrderType.ESPARZA_FOR_ARBITRARY_SYSTEMS;
        setup.MAX_BOUND = 2;
        this.unfolding = new CompletePrefixUnfolding((INetSystem)this.augmentedNet, setup);
        this.occurrenceNet = (OccurrenceNet)this.unfolding.getOccurrenceNet();
        this.deriveTransitiveCutoffRelation();
        this.deriveEventContinuation();
        this.deriveCutOfLocalConfContainsAugmentedPlaceForTransition();
        for (Node t1 : profile.getEntities()) {
            int index1 = profile.getEntities().indexOf(t1);
            for (Node t2 : profile.getEntities()) {
                int index2 = profile.getEntities().indexOf(t2);
                if (t1.equals((Object)t2)) {
                    cooccurrenceMatrix[index1][index2] = true;
                    continue;
                }
                boolean check = true;
                for (Transition e : this.occurrenceNet.getTransitions()) {
                    if (!this.cutOfLocalConfContainsAugmentedPlaceForTransition.get(e).contains(nodeMapping.get(t1)) || this.cutOfLocalConfContainsAugmentedPlaceForTransition.get(e).contains(nodeMapping.get(t2))) continue;
                    boolean foundOneForE = false;
                    for (Transition f : this.occurrenceNet.getTransitions()) {
                        if (!this.augmentationFunction.containsKey(((Event)this.occurrenceNet.getEvent((ITransition)f)).getTransition()) || !this.augmentationFunction.get(((Event)this.occurrenceNet.getEvent((ITransition)f)).getTransition()).equals(nodeMapping.get(t2)) || !e.equals((Object)f) && !this.isEventContinuation(e, f)) continue;
                        foundOneForE = true;
                        break;
                    }
                    if (check &= foundOneForE) continue;
                    break;
                }
                if (!check) continue;
                cooccurrenceMatrix[index1][index2] = true;
            }
        }
        return profile;
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(NetSystem pn, Collection<Node> nodes) {
        CausalBehaviouralProfile<NetSystem, Node> profile = new CausalBehaviouralProfile<NetSystem, Node>(pn, nodes);
        profile.setMatrix(BPCreatorUnfolding.getInstance().deriveRelationSet(pn, nodes).getMatrix());
        return this.deriveCooccurrence(profile);
    }

    protected void deriveCutOfLocalConfContainsAugmentedPlaceForTransition() {
        for (Transition e : this.occurrenceNet.getTransitions()) {
            for (Place c : this.occurrenceNet.getCutInducedByLocalConfiguration((ITransition)e)) {
                if (!this.augmentationFunction.containsKey(((Condition)this.occurrenceNet.getCondition((IPlace)c)).getPlace())) continue;
                if (!this.cutOfLocalConfContainsAugmentedPlaceForTransition.containsKey(e)) {
                    this.cutOfLocalConfContainsAugmentedPlaceForTransition.put(e, new HashSet());
                }
                this.cutOfLocalConfContainsAugmentedPlaceForTransition.get(e).add(this.augmentationFunction.get(((Condition)this.occurrenceNet.getCondition((IPlace)c)).getPlace()));
            }
        }
    }

    @Override
    public CausalBehaviouralProfile<NetSystem, Node> deriveCausalBehaviouralProfile(BehaviouralProfile<NetSystem, Node> profile) {
        CausalBehaviouralProfile<NetSystem, Node> cProfile = new CausalBehaviouralProfile<NetSystem, Node>((NetSystem)profile.getModel(), (List<Node>)profile.getEntities());
        cProfile.setMatrix(profile.getMatrix());
        return this.deriveCooccurrence(cProfile);
    }

    protected void createAugmentedNet(NetSystem pn) {
        this.augmentedNet = pn;
        for (Transition t : pn.getTransitions()) {
            Transition tstar = new Transition("AUG-T(" + t.getName() + "-star)");
            Place p_t = new Place("AUG-H2(" + t.getName() + ")");
            Place p_tstar = new Place("AUG-H1(" + t.getName() + "-star)");
            Place p_aug = new Place("AUG-P(" + t.getName() + ")");
            pn.addNode((INode)tstar);
            pn.addNode((INode)p_t);
            pn.addNode((INode)p_tstar);
            pn.putTokens((IPlace)p_tstar, Integer.valueOf(1));
            pn.addNode((INode)p_aug);
            pn.addFlow((IPlace)p_tstar, (ITransition)tstar);
            pn.addFlow((ITransition)tstar, (IPlace)p_t);
            pn.addFlow((ITransition)tstar, (IPlace)p_aug);
            for (Node pre : pn.getDirectPredecessors((IVertex)t)) {
                pn.addFlow((IPlace)((Place)pre), (ITransition)tstar);
            }
            for (Node post : pn.getDirectSuccessors((IVertex)t)) {
                pn.addFlow((ITransition)tstar, (IPlace)((Place)post));
            }
            pn.addFlow((IPlace)p_t, (ITransition)t);
            pn.addFlow((ITransition)t, (IPlace)p_t);
            this.augmentationFunction.put((Node)tstar, (Node)t);
            this.augmentationFunction.put((Node)p_aug, (Node)t);
        }
    }

    protected void deriveEventContinuation() {
        this.transitionsForEventContinutationMatrix.addAll(this.occurrenceNet.getTransitions());
        this.eventContinuationMatrix = new boolean[this.transitionsForEventContinutationMatrix.size()][this.transitionsForEventContinutationMatrix.size()];
        for (Transition e1 : this.transitionsForEventContinutationMatrix) {
            for (Transition e2 : this.transitionsForEventContinutationMatrix) {
                if (this.occurrenceNet.getOrderingRelation((INode)e1, (INode)e2).equals((Object)OrderingRelationType.CAUSAL) || !e1.equals((Object)e2) && this.occurrenceNet.getOrderingRelation((INode)e1, (INode)e2).equals((Object)OrderingRelationType.CONCURRENT)) {
                    this.eventContinuationMatrix[this.transitionsForEventContinutationMatrix.indexOf((Object)e1)][this.transitionsForEventContinutationMatrix.indexOf((Object)e2)] = true;
                    continue;
                }
                if (!this.isCausalViaSequenceOfCutOffs(e1, e2)) continue;
                this.eventContinuationMatrix[this.transitionsForEventContinutationMatrix.indexOf((Object)e1)][this.transitionsForEventContinutationMatrix.indexOf((Object)e2)] = true;
            }
        }
    }

    protected boolean isEventContinuation(Transition e, Transition f) {
        return this.eventContinuationMatrix[this.transitionsForEventContinutationMatrix.indexOf(e)][this.transitionsForEventContinutationMatrix.indexOf(f)];
    }

    private void deriveTransitiveCutoffRelation() {
        this.nodesForTransitiveCausalityMatrixUnfolding.addAll(this.occurrenceNet.getCutoffEvents());
        for (Transition t : this.occurrenceNet.getCutoffEvents()) {
            this.nodesForTransitiveCausalityMatrixUnfolding.add((Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)t));
        }
        this.transitiveCausalityMatrixUnfolding = new boolean[this.nodesForTransitiveCausalityMatrixUnfolding.size()][this.nodesForTransitiveCausalityMatrixUnfolding.size()];
        for (Transition eCut : this.occurrenceNet.getCutoffEvents()) {
            int source = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(eCut);
            int target = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(this.occurrenceNet.getCorrespondingEvent((ITransition)eCut));
            this.transitiveCausalityMatrixUnfolding[source][target] = true;
        }
        for (Transition eCut : this.occurrenceNet.getCutoffEvents()) {
            Transition eCor = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)eCut);
            while (this.occurrenceNet.getCutoffEvents().contains(eCor)) {
                eCor = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)eCor);
            }
            for (Transition eCut2 : this.occurrenceNet.getCutoffEvents()) {
                if (!this.occurrenceNet.getOrderingRelation((INode)eCor, (INode)eCut2).equals((Object)OrderingRelationType.CAUSAL)) continue;
                int source = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(eCor);
                int target = this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(eCut2);
                this.transitiveCausalityMatrixUnfolding[source][target] = true;
            }
        }
        this.transitiveCausalityMatrixUnfolding = this.computeTransitiveClosure(this.transitiveCausalityMatrixUnfolding);
    }

    private boolean[][] computeTransitiveClosure(boolean[][] matrix) {
        for (int k = 0; k < matrix.length; ++k) {
            for (int row = 0; row < matrix.length; ++row) {
                if (!matrix[row][k]) continue;
                for (int col = 0; col < matrix.length; ++col) {
                    matrix[row][col] = matrix[row][col] | matrix[k][col];
                }
            }
        }
        return matrix;
    }

    private boolean isCausalViaSequenceOfCutOffs(Transition src, Transition tar) {
        for (Transition eCut : this.occurrenceNet.getCutoffEvents()) {
            for (Transition eCut2 : this.occurrenceNet.getCutoffEvents()) {
                Transition eCor = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)eCut2);
                if (!src.equals((Object)eCut) && !this.occurrenceNet.getOrderingRelation((INode)src, (INode)eCut).equals((Object)OrderingRelationType.CAUSAL) || !this.isPathInTransitiveCausalityMatrix(eCut, eCor) || !this.occurrenceNet.getOrderingRelation((INode)eCor, (INode)tar).equals((Object)OrderingRelationType.CAUSAL) && (eCor.equals((Object)tar) || !this.occurrenceNet.getOrderingRelation((INode)eCor, (INode)tar).equals((Object)OrderingRelationType.CONCURRENT))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPathInTransitiveCausalityMatrix(Transition node1, Transition node2) {
        return this.transitiveCausalityMatrixUnfolding[this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(node1)][this.nodesForTransitiveCausalityMatrixUnfolding.indexOf(node2)];
    }
}

