/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.construct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.construct.AbstractRelSetCreator;
import org.jbpt.bp.construct.RelSetCreator;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.Transition;
import org.jbpt.petri.unfolding.CompletePrefixUnfolding;
import org.jbpt.petri.unfolding.CompletePrefixUnfoldingSetup;
import org.jbpt.petri.unfolding.Event;
import org.jbpt.petri.unfolding.OccurrenceNet;
import org.jbpt.petri.unfolding.OrderingRelationType;
import org.jbpt.petri.unfolding.order.AdequateOrderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelSetCreatorUnfolding
extends AbstractRelSetCreator
implements RelSetCreator<NetSystem, Node> {
    private static RelSetCreatorUnfolding eInstance;
    protected CompletePrefixUnfolding unfolding;
    protected OccurrenceNet occurrenceNet;
    protected long[][] stepMatrix;
    protected List<Transition> nodesForStepMatrix;
    protected boolean[][] baseOrderMatrixForTransitions;
    protected List<Transition> transitionsForBaseOrderMatrix;

    public static RelSetCreatorUnfolding getInstance() {
        if (eInstance == null) {
            eInstance = new RelSetCreatorUnfolding();
        }
        return eInstance;
    }

    private RelSetCreatorUnfolding() {
    }

    protected void clear() {
        this.unfolding = null;
        this.occurrenceNet = null;
        this.stepMatrix = null;
        this.nodesForStepMatrix = new ArrayList<Transition>();
        this.baseOrderMatrixForTransitions = null;
        this.transitionsForBaseOrderMatrix = new ArrayList<Transition>();
    }

    @Override
    public RelSet<NetSystem, Node> deriveRelationSet(NetSystem pn) {
        return this.deriveRelationSet(pn, (Collection<Node>)new ArrayList<Node>(pn.getTransitions()));
    }

    public RelSet<NetSystem, Node> deriveRelationSet(NetSystem pn, int lookAhead) {
        return this.deriveRelationSet(pn, new ArrayList<Node>(pn.getTransitions()), lookAhead);
    }

    @Override
    public RelSet<NetSystem, Node> deriveRelationSet(NetSystem pn, Collection<Node> nodes) {
        return this.deriveRelationSet(pn, nodes, 100000);
    }

    public RelSet<NetSystem, Node> deriveRelationSet(NetSystem pn, Collection<Node> nodes, int lookAhead) {
        this.clear();
        CompletePrefixUnfoldingSetup setup = new CompletePrefixUnfoldingSetup();
        setup.ADEQUATE_ORDER = AdequateOrderType.ESPARZA_FOR_ARBITRARY_SYSTEMS;
        this.unfolding = new CompletePrefixUnfolding((INetSystem)pn, setup);
        this.occurrenceNet = (OccurrenceNet)this.unfolding.getOccurrenceNet();
        this.deriveStepMatrix();
        RelSet<NetSystem, Node> rs = new RelSet<NetSystem, Node>(pn, nodes, lookAhead);
        RelSetType[][] matrix = rs.getMatrix();
        for (Node t : nodes) {
            if (!(t instanceof Transition) || this.transitionsForBaseOrderMatrix.contains((Transition)t)) continue;
            this.transitionsForBaseOrderMatrix.add((Transition)t);
        }
        this.deriveBaseOrderRelation(rs);
        for (Node t1 : rs.getEntities()) {
            int index1 = rs.getEntities().indexOf(t1);
            for (Node t2 : rs.getEntities()) {
                int index2 = rs.getEntities().indexOf(t2);
                if (index2 > index1) continue;
                if (this.isBaseOrder(t1, t2) && this.isBaseOrder(t2, t1)) {
                    super.setMatrixEntry(matrix, index1, index2, RelSetType.Interleaving);
                    continue;
                }
                if (this.isBaseOrder(t1, t2)) {
                    super.setMatrixEntryOrder(matrix, index1, index2);
                    continue;
                }
                if (this.isBaseOrder(t2, t1)) {
                    super.setMatrixEntryOrder(matrix, index2, index1);
                    continue;
                }
                super.setMatrixEntry(matrix, index1, index2, RelSetType.Exclusive);
            }
        }
        return rs;
    }

    protected void deriveBaseOrderRelation(RelSet<NetSystem, Node> rs) {
        this.baseOrderMatrixForTransitions = new boolean[this.transitionsForBaseOrderMatrix.size()][this.transitionsForBaseOrderMatrix.size()];
        for (Transition e1 : this.occurrenceNet.getTransitions()) {
            for (Transition e2 : this.occurrenceNet.getTransitions()) {
                if (this.getDistanceInStepMatrix(e1, e2) > (long)rs.getLookAhead() || !this.transitionsForBaseOrderMatrix.contains(((Event)this.occurrenceNet.getEvent((ITransition)e1)).getTransition()) || !this.transitionsForBaseOrderMatrix.contains(((Event)this.occurrenceNet.getEvent((ITransition)e2)).getTransition())) continue;
                this.baseOrderMatrixForTransitions[this.transitionsForBaseOrderMatrix.indexOf((Object)((Event)this.occurrenceNet.getEvent((ITransition)e1)).getTransition())][this.transitionsForBaseOrderMatrix.indexOf((Object)((Event)this.occurrenceNet.getEvent((ITransition)e2)).getTransition())] = true;
            }
        }
    }

    private long getDistanceInStepMatrix(Transition node1, Transition node2) {
        if (!node1.equals((Object)node2) && this.occurrenceNet.getOrderingRelation((INode)node1, (INode)node2).equals((Object)OrderingRelationType.CONCURRENT)) {
            return 1L;
        }
        return this.stepMatrix[this.nodesForStepMatrix.indexOf(node1)][this.nodesForStepMatrix.indexOf(node2)];
    }

    private boolean isBaseOrder(Node n1, Node n2) {
        return this.baseOrderMatrixForTransitions[this.transitionsForBaseOrderMatrix.indexOf(n1)][this.transitionsForBaseOrderMatrix.indexOf(n2)];
    }

    protected void deriveStepMatrix() {
        int iE2;
        int iE1;
        this.nodesForStepMatrix.addAll(this.occurrenceNet.getTransitions());
        this.stepMatrix = new long[this.nodesForStepMatrix.size()][this.nodesForStepMatrix.size()];
        for (Transition e1 : this.occurrenceNet.getTransitions()) {
            iE1 = this.nodesForStepMatrix.indexOf(e1);
            for (Transition e2 : this.occurrenceNet.getTransitions()) {
                iE2 = this.nodesForStepMatrix.indexOf(e2);
                this.stepMatrix[iE1][iE2] = 999999999L;
            }
        }
        for (Transition e1 : this.occurrenceNet.getTransitions()) {
            iE1 = this.nodesForStepMatrix.indexOf(e1);
            for (Transition e2 : this.occurrenceNet.getTransitions()) {
                iE2 = this.nodesForStepMatrix.indexOf(e2);
                for (Node c : this.occurrenceNet.getPreset((ITransition)e2)) {
                    if (!this.occurrenceNet.getPreset((INode)c).contains(e1)) continue;
                    this.stepMatrix[iE1][iE2] = 1L;
                }
            }
        }
        for (Transition cutE : this.occurrenceNet.getCutoffEvents()) {
            int iCutE = this.nodesForStepMatrix.indexOf(cutE);
            Transition corE = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)cutE);
            while (this.occurrenceNet.getCutoffEvents().contains(corE)) {
                corE = (Transition)this.occurrenceNet.getCorrespondingEvent((ITransition)corE);
            }
            for (Node c : this.occurrenceNet.getPostset((ITransition)corE)) {
                for (Node e : this.occurrenceNet.getPostset((INode)c)) {
                    int iE = this.nodesForStepMatrix.indexOf(e);
                    this.stepMatrix[iCutE][iE] = 1L;
                }
            }
        }
        for (int r = 0; r < this.nodesForStepMatrix.size(); ++r) {
            for (Transition e1 : this.occurrenceNet.getTransitions()) {
                int iE12 = this.nodesForStepMatrix.indexOf(e1);
                for (Transition e2 : this.occurrenceNet.getTransitions()) {
                    int iE22 = this.nodesForStepMatrix.indexOf(e2);
                    this.stepMatrix[iE12][iE22] = Math.min(this.stepMatrix[iE12][iE22], this.stepMatrix[iE12][r] + this.stepMatrix[r][iE22]);
                }
            }
        }
    }
}

