/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.sim;

import org.jbpt.alignment.Alignment;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.sim.RelSetSimilarity;
import org.jbpt.bp.sim.RelSetSizeCache;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRelSetSimilarity<R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity>
implements RelSetSimilarity<R, M, N> {
    @Override
    public String getName() {
        return this.getClass().getName();
    }

    protected int getSizeOfIntersectionOfRelation(Alignment<R, N> alignment, RelSetType relation) {
        return this.getSizeOfIntersectionOfTwoRelations(alignment, relation, relation);
    }

    protected int getSizeOfIntersectionOfTwoRelations(Alignment<R, N> alignment, RelSetType relation1, RelSetType relation2) {
        int sizeOfIntersection = 0;
        for (IEntity n1 : ((RelSet)alignment.getFirstModel()).getEntities()) {
            if (n1 instanceof Place || ((Transition)n1).isSilent()) continue;
            for (IEntity n2 : ((RelSet)alignment.getFirstModel()).getEntities()) {
                if (n2 instanceof Place || ((Transition)n2).isSilent() || !((RelSet)alignment.getFirstModel()).getRelationForEntities(n1, n2).equals((Object)relation1) || !alignment.getAlignedEntitiesOfFirstModel().contains(n1) || !alignment.getAlignedEntitiesOfFirstModel().contains(n2) || !((RelSet)alignment.getSecondModel()).getRelationForEntities((IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(n1).iterator().next(), (IEntity)alignment.getCorrespondingEntitiesForEntityOfFirstModel(n2).iterator().next()).equals((Object)relation2)) continue;
                ++sizeOfIntersection;
            }
        }
        return sizeOfIntersection;
    }

    protected int getSizeOfRelation(R rs, RelSetType relation) {
        if (RelSetSizeCache.getInstance().containsEntry((RelSet)rs, relation)) {
            return RelSetSizeCache.getInstance().getRelationSize((RelSet)rs, relation);
        }
        int sizeOfRelation = 0;
        for (IEntity n1 : ((RelSet)rs).getEntities()) {
            if (n1 instanceof Place || ((Transition)n1).isSilent()) continue;
            for (IEntity n2 : ((RelSet)rs).getEntities()) {
                if (n2 instanceof Place || ((Transition)n2).isSilent() || !((RelSet)rs).getRelationForEntities((IEntity)n1, (IEntity)n2).equals((Object)relation)) continue;
                ++sizeOfRelation;
            }
        }
        RelSetSizeCache.getInstance().addEntry((RelSet)rs, relation, sizeOfRelation);
        if (relation.equals((Object)RelSetType.Order)) {
            RelSetSizeCache.getInstance().addEntry((RelSet)rs, RelSetType.ReverseOrder, sizeOfRelation);
        }
        if (relation.equals((Object)RelSetType.ReverseOrder)) {
            RelSetSizeCache.getInstance().addEntry((RelSet)rs, RelSetType.Order, sizeOfRelation);
        }
        return sizeOfRelation;
    }
}

