/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.bp.sim;

import org.jbpt.alignment.Alignment;
import org.jbpt.bp.RelSet;
import org.jbpt.bp.RelSetType;
import org.jbpt.bp.sim.AbstractRelSetSimilarity;
import org.jbpt.hypergraph.abs.IEntity;
import org.jbpt.hypergraph.abs.IEntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusivenessSimilarity<R extends RelSet<M, N>, M extends IEntityModel<N>, N extends IEntity>
extends AbstractRelSetSimilarity<R, M, N> {
    @Override
    public double score(Alignment<R, N> alignment) {
        double in1 = super.getSizeOfRelation((RelSet)alignment.getFirstModel(), RelSetType.Exclusive);
        double in2 = super.getSizeOfRelation((RelSet)alignment.getSecondModel(), RelSetType.Exclusive);
        double intersection = super.getSizeOfIntersectionOfRelation(alignment, RelSetType.Exclusive);
        return intersection > 0.0 ? intersection / (in1 + in2 - intersection) : 0.0;
    }

    @Override
    public double scoreDice(Alignment<R, N> alignment) {
        double in1 = super.getSizeOfRelation((RelSet)alignment.getFirstModel(), RelSetType.Exclusive);
        double in2 = super.getSizeOfRelation((RelSet)alignment.getSecondModel(), RelSetType.Exclusive);
        double intersection = super.getSizeOfIntersectionOfRelation(alignment, RelSetType.Exclusive);
        return in1 + in2 > 0.0 ? 2.0 * intersection / (in1 + in2) : 0.0;
    }
}

