/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.automaton;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jbpt.algo.graph.DirectedGraphAlgorithms;
import org.jbpt.automaton.AbstractStateTransition;
import org.jbpt.automaton.IAutomaton;
import org.jbpt.automaton.IState;
import org.jbpt.automaton.IStateTransition;
import org.jbpt.automaton.State;
import org.jbpt.graph.abs.AbstractMultiDirectedGraph;
import org.jbpt.graph.abs.IDirectedGraph;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;

public class AbstractAutomaton<ST extends IStateTransition<S, F, N, P, T, M>, S extends IState<F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractMultiDirectedGraph<ST, S>
implements IAutomaton<ST, S, F, N, P, T, M> {
    private DirectedGraphAlgorithms<ST, S> DGA = new DirectedGraphAlgorithms();
    private INetSystem<F, N, P, T, M> sys = null;
    private Map<M, S> m2s = null;
    private boolean isComplete = false;
    private S startState = null;

    public ST addEdge(S s, S t) {
        if (s == null || t == null) {
            return null;
        }
        AbstractStateTransition st = new AbstractStateTransition(this, s, t);
        return (ST)st;
    }

    public AbstractAutomaton(INetSystem<F, N, P, T, M> sys) {
        this.construct(sys, Integer.MAX_VALUE);
    }

    public AbstractAutomaton(INetSystem<F, N, P, T, M> sys, int maxSize) {
        this.construct(sys, maxSize);
    }

    public AbstractAutomaton() {
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean isReachable(M marking) {
        return this.m2s.containsKey(marking);
    }

    @Override
    public boolean isReachable(M fromMarking, M toMarking) {
        if (!this.m2s.containsKey(fromMarking)) {
            return false;
        }
        if (!this.m2s.containsKey(toMarking)) {
            return false;
        }
        return this.DGA.hasPath((IDirectedGraph)this, (IVertex)((IState)this.m2s.get(fromMarking)), (IVertex)((IState)this.m2s.get(toMarking)));
    }

    @Override
    public INetSystem<F, N, P, T, M> getNetSystem() {
        return this.sys;
    }

    @Override
    public void construct(INetSystem<F, N, P, T, M> sys, int maxSize) {
        this.sys = sys;
        this.m2s = new HashMap<M, S>();
        if (maxSize <= 0) {
            if (this.sys != null) {
                this.isComplete = false;
            }
            return;
        }
        S ini = this.createState(this.sys.getMarking());
        this.addVertex((IVertex)ini);
        this.startState = ini;
        ConcurrentLinkedQueue<S> queue = new ConcurrentLinkedQueue<S>();
        queue.add(ini);
        this.m2s.put(this.sys.getMarking(), ini);
        while (!queue.isEmpty()) {
            IState v = (IState)queue.poll();
            Set<T> enabled = this.sys.getEnabledTransitionsAtMarking(v.getMarking());
            for (ITransition t : enabled) {
                IMarking freshMarking = v.getMarking().clone();
                freshMarking.fire(t);
                if (this.m2s.containsKey(freshMarking)) {
                    ST edge = this.addEdge((S)v, (S)((IState)this.m2s.get(freshMarking)));
                    edge.setTransition((ITransition)t);
                    continue;
                }
                if (this.m2s.size() >= maxSize) {
                    if (!queue.isEmpty()) {
                        this.isComplete = false;
                    }
                    return;
                }
                S state = this.createState(freshMarking);
                this.m2s.put(freshMarking, state);
                queue.add(state);
                ST edge = this.addEdge(v, state);
                edge.setTransition((ITransition)t);
            }
        }
        this.isComplete = true;
    }

    private S createState(M marking) {
        IState state;
        try {
            state = (IState)State.class.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        state.setMarking(marking);
        return (S)state;
    }

    public String toDOT() {
        String result = "digraph G {\n";
        result = String.valueOf(result) + "graph [fontname=\"Helvetica\" fontsize=\"10\"];\n";
        result = String.valueOf(result) + "node [fontname=\"Helvetica\" fontsize=\"10\"];\n";
        for (IState s : this.getStates()) {
            result = String.valueOf(result) + String.format("\tstate%s[label=\"\" shape=\"point\" width=\".075\" height=\".075\"];\n", s.getId().replace("-", ""));
            result = String.valueOf(result) + String.format("\tmarking%s[label=\"%s\" shape=\"plaintext\"];\n", s.getId().replace("-", ""), s.getMarking().toMultiSet().toString());
        }
        result = String.valueOf(result) + "\n";
        for (IState s : this.getStates()) {
            result = String.valueOf(result) + String.format("\tstate%s->marking%s [style=\"dotted\", arrowhead=\"odot\", arrowsize=\"0\"];\n", s.getId().replace("-", ""), s.getId().replace("-", ""));
        }
        for (IStateTransition st : this.getStateTransitions()) {
            result = String.valueOf(result) + String.format("\tstate%s->state%s [label=\"%s\" fontname=\"Helvetica\" fontsize=\"10\" arrowhead=\"normal\" arrowsize=\".75\" color=\"black\"];\n", ((IState)st.getSource()).getId().replace("-", ""), ((IState)st.getTarget()).getId().replace("-", ""), st.getSymbol());
        }
        result = String.valueOf(result) + "}\n";
        return result;
    }

    @Override
    public Set<S> getStates() {
        return new HashSet(this.getVertices());
    }

    @Override
    public Set<ST> getStateTransitions() {
        return new HashSet(this.getEdges());
    }

    @Override
    public S getStartState() {
        return this.startState;
    }
}

