/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.Marking;
import org.jbpt.petri.Place;

public abstract class AbstractMarking<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition>
extends HashMap<P, Integer>
implements IMarking<F, N, P, T> {
    private static final long serialVersionUID = -2144274745926614966L;
    private IPetriNet<F, N, P, T> net = null;

    public AbstractMarking() {
    }

    public AbstractMarking(IPetriNet<F, N, P, T> net) {
        if (net == null) {
            throw new IllegalArgumentException("PetriNet object expected but was NULL!");
        }
        this.net = net;
    }

    @Override
    public Integer put(P p, Integer tokens) {
        if (p == null) {
            return 0;
        }
        if (!this.net.getPlaces().contains(p)) {
            throw new IllegalArgumentException("Proposed place is not part of the associated net!");
        }
        Integer result = null;
        result = tokens == null ? (Integer)super.remove(p) : (tokens <= 0 ? (Integer)super.remove(p) : super.put(p, tokens));
        return result == null ? 0 : result;
    }

    @Override
    public IPetriNet<F, N, P, T> getPetriNet() {
        return this.net;
    }

    @Override
    public boolean isMarked(P place) {
        return this.get(place) > 0;
    }

    @Override
    public Collection<P> toMultiSet() {
        ArrayList<IPlace> result = new ArrayList<IPlace>();
        for (Map.Entry<P, Integer> entry : this.entrySet()) {
            int i = 0;
            while (i < entry.getValue()) {
                result.add((IPlace)entry.getKey());
                ++i;
            }
        }
        return result;
    }

    @Override
    public void fromMultiSet(Collection<P> places) {
        this.clear();
        for (IPlace p : places) {
            if (!this.net.getPlaces().contains(p)) continue;
            Integer tokens = this.get((P)p);
            if (tokens == null) {
                this.put((P)p, 1);
                continue;
            }
            this.put((P)p, tokens + 1);
        }
    }

    @Override
    public Integer remove(P place) {
        return (Integer)super.remove(place);
    }

    @Override
    public Integer get(P place) {
        Integer i = (Integer)super.get(place);
        return i == null ? 0 : i;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Integer remove(Object place) {
        return (Integer)super.remove(place);
    }

    @Override
    public void putAll(Map<? extends P, ? extends Integer> m) {
        for (Map.Entry<P, Integer> entry : m.entrySet()) {
            this.put((P)((IPlace)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public Integer get(Object p) {
        if (!(p instanceof Place)) {
            return 0;
        }
        Integer i = (Integer)super.get(p);
        return i == null ? 0 : i;
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public Set<Map.Entry<P, Integer>> entrySet() {
        return super.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IMarking)) {
            return false;
        }
        IMarking that = (IMarking)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (Map.Entry<P, Integer> i : this.entrySet()) {
            Integer value = that.get((IPlace)i.getKey());
            if (value == null) {
                return false;
            }
            if (i.getValue().equals(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result -= this.net.hashCode();
        for (IPlace p : this.net.getPlaces()) {
            result += 17 * p.hashCode() * this.get((P)p);
        }
        return result;
    }

    @Override
    public IMarking<F, N, P, T> createMarking(IPetriNet<F, N, P, T> net) {
        IMarking m = null;
        try {
            m = (IMarking)Marking.class.newInstance();
            m.setPetriNet(net);
            return m;
        }
        catch (IllegalAccessException exception) {
            return m;
        }
        catch (InstantiationException exception) {
            return m;
        }
    }

    @Override
    public void setPetriNet(IPetriNet<F, N, P, T> net) {
        this.clear();
        this.net = net;
    }

    @Override
    public boolean fire(T transition) {
        if (!this.net.getTransitions().contains(transition)) {
            return false;
        }
        for (IPlace p : this.net.getPreset(transition)) {
            if (this.get((P)p) != 0) continue;
            return false;
        }
        for (IPlace p : this.net.getPreset(transition)) {
            this.put((P)p, this.get((P)p) - 1);
        }
        for (IPlace p : this.net.getPostset(transition)) {
            this.put((P)p, this.get((P)p) + 1);
        }
        return true;
    }

    @Override
    public IMarking<F, N, P, T> clone() {
        AbstractMarking cloneMarking = (AbstractMarking)super.clone();
        cloneMarking.net = this.net;
        return cloneMarking;
    }

    @Override
    public boolean isBounded(int n) {
        for (Map.Entry<P, Integer> entry : this.entrySet()) {
            if (entry.getValue() <= n) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSafe() {
        return this.isBounded(1);
    }
}

