/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.AbstractPetriNet;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.Marking;
import org.jbpt.petri.NetSystem;

public abstract class AbstractNetSystem<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractPetriNet<F, N, P, T>
implements INetSystem<F, N, P, T, M> {
    protected M marking = null;

    public AbstractNetSystem() {
        try {
            this.marking = (IMarking)Marking.class.newInstance();
            this.marking.setPetriNet(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public N removeNode(N n) {
        N result = super.removeNode(n);
        if (result != null && n instanceof IPlace) {
            this.marking.remove(n);
        }
        return result;
    }

    @Override
    public Collection<N> removeNodes(Collection<N> ns) {
        Collection<N> result = super.removeNodes(ns);
        if (result != null) {
            for (INode n : result) {
                if (!(n instanceof IPlace)) continue;
                this.marking.remove(n);
            }
        }
        return result;
    }

    @Override
    public P removePlace(P p) {
        P result = super.removePlace(p);
        if (result != null) {
            this.marking.remove(p);
        }
        return result;
    }

    @Override
    public Collection<P> removePlaces(Collection<P> ps) {
        Collection<P> result = super.removePlaces(ps);
        if (result != null) {
            for (IPlace p : result) {
                this.marking.remove((IPlace)p);
            }
        }
        return result;
    }

    @Override
    public M getMarking() {
        return this.marking;
    }

    @Override
    public Set<P> getMarkedPlaces() {
        return this.marking.keySet();
    }

    @Override
    public Set<T> getEnabledTransitions() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (ITransition t : this.getTransitions()) {
            if (!this.getMarkedPlaces().containsAll(this.getPreset(t))) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public Set<T> getEnabledTransitions(Set<T> lastEnabled, T lastFired) {
        HashSet<T> enabled = new HashSet<T>(lastEnabled);
        for (ITransition t : lastEnabled) {
            if (this.getMarkedPlaces().containsAll(this.getPreset(t))) continue;
            enabled.remove(t);
        }
        for (IPlace p : this.getPostset(lastFired)) {
            for (ITransition iTransition : this.getPostset(p)) {
                if (!this.getMarkedPlaces().containsAll(this.getPreset(iTransition))) continue;
                enabled.add(iTransition);
            }
        }
        return enabled;
    }

    @Override
    public Set<T> getEnabledTransitionsAtMarking(M marking) {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (ITransition t : this.getTransitions()) {
            boolean flag = true;
            for (IPlace iPlace : this.getPreset(t)) {
                if (marking.isMarked((IPlace)iPlace)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public boolean isEnabled(T t) {
        if (!this.getTransitions().contains(t)) {
            return false;
        }
        for (IPlace p : this.getPreset(t)) {
            if (this.isMarked(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMarked(P p) {
        return this.marking.isMarked(p);
    }

    @Override
    public boolean fire(T transition) {
        return this.marking.fire(transition);
    }

    @Override
    public String toDOT() {
        String result = "digraph G {\n";
        result = String.valueOf(result) + "graph [fontname=\"Helvetica\" fontsize=\"10\" nodesep=\"0.35\" ranksep=\"0.25 equally\"];\n";
        result = String.valueOf(result) + "node [fontname=\"Helvetica\" fontsize=\"10\" fixedsize=\"true\" style=\"filled\" fillcolor=\"white\" penwidth=\"2\"];\n";
        result = String.valueOf(result) + "edge [fontname=\"Helvetica\" fontsize=\"10\" arrowhead=\"normal\" color=\"black\"];\n";
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=\"circle\"];\n";
        for (IPlace p : this.getPlaces()) {
            Integer n = this.marking.get((IPlace)p);
            String label = n == 0 || n == null ? p.getName() : String.valueOf(p.getName()) + "[" + n.toString() + "]";
            result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".3\" height=\".3\"];\n", p.getId().replace("-", ""), label);
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=\"box\"];\n";
        for (ITransition t : this.getTransitions()) {
            String fillColor = this.isEnabled(t) ? " fillcolor=\"#9ACD32\"" : "";
            result = t.isSilent() ? String.valueOf(result) + String.format("\tn%s[label=\"\" width=\".3\"" + fillColor + " height=\".1\"];\n", t.getId().replace("-", "")) : String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".3\"" + fillColor + " height=\".3\"];\n", t.getId().replace("-", ""), t.getLabel());
        }
        result = String.valueOf(result) + "\n";
        for (IFlow f : this.getFlow()) {
            result = String.valueOf(result) + String.format("\tn%s->n%s;\n", ((INode)f.getSource()).getId().replace("-", ""), ((INode)f.getTarget()).getId().replace("-", ""));
        }
        result = String.valueOf(result) + "}\n";
        return result;
    }

    @Override
    public INetSystem<F, N, P, T, M> clone() {
        return this.clone((Map)new HashMap());
    }

    @Override
    public INetSystem<F, N, P, T, M> clone(Map<N, N> map) {
        INetSystem clone = null;
        try {
            clone = (INetSystem)NetSystem.class.newInstance();
        }
        catch (InstantiationException exception) {
            return null;
        }
        catch (IllegalAccessException exception) {
            return null;
        }
        for (IPlace p : this.getPlaces()) {
            IPlace np = p.clone();
            map.put(p, np);
            clone.addPlace(np);
        }
        for (ITransition t : this.getTransitions()) {
            ITransition nt = t.clone();
            map.put(t, nt);
            clone.addTransition(nt);
        }
        for (IFlow f : this.getFlow()) {
            clone.addFlow((INode)map.get(f.getSource()), (INode)map.get(f.getTarget()));
        }
        for (IPlace p : this.getPlaces()) {
            clone.putTokens((IPlace)map.get(p), this.getTokens(p));
        }
        return clone;
    }

    @Override
    public Integer putTokens(P p, Integer tokens) {
        return this.marking.put(p, tokens);
    }

    @Override
    public Integer getTokens(P p) {
        return this.marking.get(p);
    }

    @Override
    public void loadNaturalMarking() {
        this.marking.clear();
        for (IPlace p : this.getSourcePlaces()) {
            this.marking.put((IPlace)p, 1);
        }
    }

    @Override
    public void loadMarking(M newMarking) {
        if (newMarking.getPetriNet() != this) {
            return;
        }
        if (this.marking.equals(newMarking)) {
            return;
        }
        this.marking.clear();
        for (Map.Entry entry : newMarking.entrySet()) {
            this.marking.put((IPlace)((IPlace)entry.getKey()), (Integer)entry.getValue());
        }
    }

    @Override
    public IMarking<F, N, P, T> createMarking() {
        return this.marking.createMarking(this);
    }
}

