/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.graph.abs.AbstractDirectedGraph;
import org.jbpt.hypergraph.abs.IHyperEdge;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.PetriNet;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;

public abstract class AbstractPetriNet<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition>
extends AbstractDirectedGraph<F, N>
implements IPetriNet<F, N, P, T> {
    @Override
    public F addFlow(P place, T transition) {
        return this.addFlow((T)place, (P)transition);
    }

    @Override
    public F addFlow(T transition, P place) {
        return this.addFlow(transition, place);
    }

    @Override
    public N addNode(N node) {
        return (N)((INode)this.addVertex((IVertex)node));
    }

    @Override
    public Collection<N> addNodes(Collection<N> nodes) {
        Collection result = this.addVertices(nodes);
        return result == null ? new ArrayList() : result;
    }

    @Override
    public P addPlace(P place) {
        return this.addVertex((IVertex)place) == null ? null : (P)place;
    }

    @Override
    public Collection<P> addPlaces(Collection<P> places) {
        ArrayList<IPlace> result = new ArrayList<IPlace>();
        if (places == null) {
            return result;
        }
        for (IPlace place : places) {
            if (this.addVertex(place) == null) continue;
            result.add(place);
        }
        return result;
    }

    @Override
    public T addTransition(T transition) {
        return this.addVertex((IVertex)transition) == null ? null : (T)transition;
    }

    @Override
    public Collection<T> addTransitions(Collection<T> transitions) {
        ArrayList<ITransition> result = new ArrayList<ITransition>();
        if (transitions == null) {
            return result;
        }
        for (ITransition transition : transitions) {
            if (this.addVertex(transition) == null) continue;
            result.add(transition);
        }
        return result;
    }

    @Override
    public N removeNode(N node) {
        return (N)((INode)this.removeVertex((IVertex)node));
    }

    @Override
    public Collection<N> removeNodes(Collection<N> nodes) {
        Collection result = this.removeVertices(nodes);
        return result == null ? new ArrayList() : result;
    }

    @Override
    public P removePlace(P place) {
        return this.removeVertex((IVertex)place) == null ? null : (P)place;
    }

    @Override
    public Collection<P> removePlaces(Collection<P> places) {
        ArrayList<IPlace> result = new ArrayList<IPlace>();
        if (places == null) {
            return result;
        }
        for (IPlace place : places) {
            if (this.removeVertex(place) == null) continue;
            result.add(place);
        }
        return result;
    }

    @Override
    public T removeTransition(T transition) {
        return this.removeVertex((IVertex)transition) == null ? null : (T)transition;
    }

    @Override
    public Collection<T> removeTransitions(Collection<T> transitions) {
        ArrayList<ITransition> result = new ArrayList<ITransition>();
        if (transitions == null) {
            return result;
        }
        for (ITransition transition : transitions) {
            if (this.removeVertex(transition) == null) continue;
            result.add(transition);
        }
        return result;
    }

    @Override
    public F removeFlow(F flow) {
        return (F)((IFlow)this.removeEdge((IHyperEdge)flow));
    }

    @Override
    public Collection<F> removeFlow(Collection<F> flow) {
        Collection result = this.removeEdges(flow);
        return result == null ? new ArrayList() : result;
    }

    @Override
    public Set<N> getNodes() {
        return new HashSet(this.getVertices());
    }

    @Override
    public Set<P> getPlaces() {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (INode node : this.getVertices()) {
            if (!(node instanceof IPlace)) continue;
            result.add((IPlace)node);
        }
        return result;
    }

    @Override
    public Set<T> getTransitions() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getVertices()) {
            if (!(node instanceof ITransition)) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<F> getFlow() {
        return new HashSet(this.getEdges());
    }

    @Override
    public Set<T> getSilentTransitions() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getVertices()) {
            if (!(node instanceof ITransition) || !node.getLabel().isEmpty()) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<T> getObservableTransitions() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getVertices()) {
            if (!(node instanceof ITransition) || node.getLabel().isEmpty()) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<P> getPostset(T transition) {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (INode node : this.getDirectSuccessors((IVertex)transition)) {
            if (!(node instanceof IPlace)) continue;
            result.add((IPlace)node);
        }
        return result;
    }

    @Override
    public Set<P> getPostsetPlaces(Collection<T> transitions) {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (ITransition transition : transitions) {
            for (INode node : this.getDirectSuccessors(transition)) {
                if (!(node instanceof IPlace)) continue;
                result.add((IPlace)node);
            }
        }
        return result;
    }

    @Override
    public Set<T> getPostset(P place) {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getDirectSuccessors((IVertex)place)) {
            if (!(node instanceof ITransition)) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<T> getPostsetTransitions(Collection<P> places) {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (IPlace place : places) {
            for (INode node : this.getDirectSuccessors(place)) {
                if (!(node instanceof ITransition)) continue;
                result.add((ITransition)node);
            }
        }
        return result;
    }

    @Override
    public Set<N> getPostset(N node) {
        return new HashSet(this.getDirectSuccessors((IVertex)node));
    }

    @Override
    public Set<N> getPostset(Collection<N> nodes) {
        return new HashSet(this.getDirectSuccessors(nodes));
    }

    @Override
    public Set<P> getPreset(T transition) {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (INode node : this.getDirectPredecessors((IVertex)transition)) {
            if (!(node instanceof IPlace)) continue;
            result.add((IPlace)node);
        }
        return result;
    }

    @Override
    public Set<P> getPresetPlaces(Collection<T> transitions) {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (ITransition transition : transitions) {
            for (INode node : this.getDirectPredecessors(transition)) {
                if (!(node instanceof IPlace)) continue;
                result.add((IPlace)node);
            }
        }
        return result;
    }

    @Override
    public Set<T> getPreset(P place) {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getDirectPredecessors((IVertex)place)) {
            if (!(node instanceof ITransition)) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<T> getPresetTransitions(Collection<P> places) {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (IPlace place : places) {
            for (INode node : this.getDirectPredecessors(place)) {
                if (!(node instanceof ITransition)) continue;
                result.add((ITransition)node);
            }
        }
        return result;
    }

    @Override
    public Set<N> getPreset(N node) {
        return new HashSet(this.getDirectPredecessors((IVertex)node));
    }

    @Override
    public Set<N> getPreset(Collection<N> nodes) {
        return new HashSet(this.getDirectPredecessors(nodes));
    }

    @Override
    public Set<P> getSourcePlaces() {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (INode node : this.getSourceNodes()) {
            if (!(node instanceof IPlace)) continue;
            result.add((IPlace)node);
        }
        return result;
    }

    @Override
    public Set<T> getSourceTransitions() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getSourceNodes()) {
            if (!(node instanceof ITransition)) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<P> getSinkPlaces() {
        HashSet<IPlace> result = new HashSet<IPlace>();
        for (INode node : this.getSinkNodes()) {
            if (!(node instanceof IPlace)) continue;
            result.add((IPlace)node);
        }
        return result;
    }

    @Override
    public Set<T> getSinkTransitions() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        for (INode node : this.getSinkNodes()) {
            if (!(node instanceof ITransition)) continue;
            result.add((ITransition)node);
        }
        return result;
    }

    @Override
    public Set<N> getMin() {
        return this.getSourceNodes();
    }

    @Override
    public Set<N> getMax() {
        return this.getSinkNodes();
    }

    @Override
    public Set<N> getSourceNodes() {
        HashSet<INode> result = new HashSet<INode>();
        for (INode n : this.getNodes()) {
            if (!this.getPreset((N)n).isEmpty()) continue;
            result.add(n);
        }
        return result;
    }

    @Override
    public Set<N> getSinkNodes() {
        HashSet<INode> result = new HashSet<INode>();
        for (INode n : this.getNodes()) {
            if (!this.getPostset((N)n).isEmpty()) continue;
            result.add(n);
        }
        return result;
    }

    @Override
    public IPetriNet<F, N, P, T> clone() {
        return this.clone(new HashMap());
    }

    @Override
    public IPetriNet<F, N, P, T> clone(Map<N, N> map) {
        IPetriNet clone = null;
        try {
            clone = (IPetriNet)PetriNet.class.newInstance();
        }
        catch (InstantiationException exception) {
            return null;
        }
        catch (IllegalAccessException exception) {
            return null;
        }
        for (IPlace p : this.getPlaces()) {
            IPlace np = p.clone();
            map.put(p, np);
            clone.addPlace(np);
        }
        for (ITransition t : this.getTransitions()) {
            ITransition nt = t.clone();
            map.put(t, nt);
            clone.addTransition(nt);
        }
        for (IFlow f : this.getFlow()) {
            clone.addFlow((INode)map.get(f.getSource()), (INode)map.get(f.getTarget()));
        }
        return clone;
    }

    public String toDOT() {
        String result = "digraph G {\n";
        result = String.valueOf(result) + "graph [fontname=\"Helvetica\" fontsize=\"10\" nodesep=\"0.35\" ranksep=\"0.25 equally\"];\n";
        result = String.valueOf(result) + "node [fontname=\"Helvetica\" fontsize=\"10\" fixedsize=\"true\" style=\"filled\" fillcolor=\"white\" penwidth=\"2\"];\n";
        result = String.valueOf(result) + "edge [fontname=\"Helvetica\" fontsize=\"10\" arrowhead=\"normal\" color=\"black\"];\n";
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=circle];\n";
        for (IPlace place : this.getPlaces()) {
            result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".3\" height=\".3\"];\n", place.getId().replace("-", ""), place.getLabel());
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=box];\n";
        for (ITransition transition : this.getTransitions()) {
            result = transition.isSilent() ? String.valueOf(result) + String.format("\tn%s[label=\"\" width=\".3\" height=\".1\"];\n", transition.getId().replace("-", "")) : String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".3\" height=\".3\"];\n", transition.getId().replace("-", ""), transition.getLabel());
        }
        result = String.valueOf(result) + "\n";
        for (IFlow flow : this.getFlow()) {
            result = String.valueOf(result) + String.format("\tn%s->n%s;\n", ((INode)flow.getSource()).getId().replace("-", ""), ((INode)flow.getTarget()).getId().replace("-", ""));
        }
        result = String.valueOf(result) + "}\n";
        return result;
    }

    @Override
    public T createTransition() {
        ITransition t = null;
        try {
            t = (ITransition)Transition.class.newInstance();
            return (T)t;
        }
        catch (InstantiationException exception) {
            return (T)t;
        }
        catch (IllegalAccessException exception) {
            return (T)t;
        }
    }

    @Override
    public P createPlace() {
        IPlace p = null;
        try {
            p = (IPlace)Place.class.newInstance();
            return (P)p;
        }
        catch (InstantiationException exception) {
            return (P)p;
        }
        catch (IllegalAccessException exception) {
            return (P)p;
        }
    }

    @Override
    public void clear() {
        this.removeVertices(this.getVertices());
    }
}

