/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri;

import org.jbpt.hypergraph.abs.Vertex;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.IStep;
import org.jbpt.petri.ITransition;

public class AbstractStep<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends Vertex
implements IStep<F, N, P, T, M> {
    protected IPetriNet<F, N, P, T> net = null;
    protected M inputMarking = null;
    protected M outputMarking = null;
    protected T transition = null;

    protected AbstractStep() {
        this(null, null, null, null);
    }

    public AbstractStep(IPetriNet<F, N, P, T> net, M inputMarking, T transition) {
        this.net = net;
        this.inputMarking = inputMarking;
        this.transition = transition;
        if (this.net == null) {
            throw new IllegalArgumentException("Net is null.");
        }
        if (this.net != this.inputMarking.getPetriNet()) {
            throw new IllegalArgumentException("Marking does not correspond to the net.");
        }
        for (IPlace p : this.net.getPreset(this.transition)) {
            if (this.inputMarking.isMarked((IPlace)p)) continue;
            throw new IllegalArgumentException("Transition is not enabled in the net at the input marking.");
        }
        this.outputMarking = this.inputMarking.clone();
        this.outputMarking.fire(this.transition);
    }

    public AbstractStep(IPetriNet<F, N, P, T> net, M inputMarking, T transition, M outputMarking) {
        this.net = net;
        this.inputMarking = inputMarking;
        this.transition = transition;
        this.outputMarking = outputMarking;
    }

    @Override
    public M getInputMarking() {
        return this.inputMarking;
    }

    @Override
    public M getOutputMarking() {
        return this.outputMarking;
    }

    @Override
    public T getTransition() {
        return this.transition;
    }

    @Override
    public IPetriNet<F, N, P, T> getPetriNet() {
        return this.net;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof IStep)) {
            return false;
        }
        IStep that = (IStep)arg0;
        if (this.getPetriNet() != that.getPetriNet()) {
            return false;
        }
        if (this.getInputMarking() == null ? that.getInputMarking() != null : !this.getInputMarking().equals(that.getInputMarking())) {
            return false;
        }
        if (this.getOutputMarking() == null ? that.getOutputMarking() != null : !this.getOutputMarking().equals(that.getOutputMarking())) {
            return false;
        }
        return !(this.getTransition() == null ? that.getTransition() != null : !this.getTransition().equals(that.getTransition()));
    }

    public int hashCode() {
        return this.inputMarking.hashCode() + 7 * this.transition.hashCode() + 11 * this.outputMarking.hashCode();
    }

    public String toString() {
        return String.format("%s[%s>%s", this.inputMarking == null ? "null" : this.inputMarking.toString(), this.transition == null ? "null" : this.transition.toString(), this.outputMarking == null ? "null" : this.outputMarking.toString());
    }

    @Override
    public T getCommand() {
        return this.transition;
    }

    public String getLabel() {
        return this.toString();
    }
}

