/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri;

import java.util.ArrayList;
import org.jbpt.petri.AbstractNetSystem;
import org.jbpt.petri.Flow;
import org.jbpt.petri.Marking;
import org.jbpt.petri.Node;
import org.jbpt.petri.PetriNet;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;

public class NetSystem
extends AbstractNetSystem<Flow, Node, Place, Transition, Marking> {
    public NetSystem() {
        try {
            this.marking = (Marking)Marking.class.newInstance();
            ((Marking)this.marking).setPetriNet(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public NetSystem(PetriNet petriNet) {
        this();
        for (Node n : petriNet.getNodes()) {
            this.addNode(n);
        }
        for (Flow f : petriNet.getFlow()) {
            this.addFlow((Node)f.getSource(), (Node)f.getTarget());
        }
    }

    @Override
    public Flow addFlow(Node from, Node to) {
        if (from == null || to == null) {
            return null;
        }
        if (from instanceof Place && to instanceof Transition || from instanceof Transition && to instanceof Place) {
            ArrayList<Node> ss = new ArrayList<Node>();
            ss.add(from);
            ArrayList<Node> ts = new ArrayList<Node>();
            ts.add(to);
            if (!this.checkEdge(ss, ts)) {
                return null;
            }
            return new Flow(this, from, to);
        }
        return null;
    }
}

