/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.PetriNet;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;

public class ConcurrencyRelation {
    private NetSystem sys;
    private List<Node> nodes;
    private boolean[][] matrix;
    private Map<Node, Set<Node>> indirectPlaces;

    public ConcurrencyRelation(NetSystem sys) {
        this.sys = sys;
        this.matrix = null;
        this.nodes = new ArrayList(this.sys.getNodes());
        this.indirectPlaces = new HashMap<Node, Set<Node>>();
    }

    public boolean areConcurrent(Node n1, Node n2) {
        if (this.matrix == null) {
            this.calculateConcurrencyMatrix();
        }
        int index1 = this.nodes.indexOf(n1);
        int index2 = this.nodes.indexOf(n2);
        return this.matrix[index1][index2];
    }

    public boolean areConcurrent(int i, int j) {
        if (this.matrix == null) {
            this.calculateConcurrencyMatrix();
        }
        return this.matrix[i][j];
    }

    protected boolean nodeConcurrentToNodes(Node n, Collection<Node> nodes) {
        boolean conc = true;
        int i = this.nodes.indexOf(n);
        for (Node n2 : nodes) {
            int j = this.nodes.indexOf(n2);
            conc &= this.matrix[i][j];
        }
        return conc;
    }

    protected void setAllNodesConcurrent(Collection<Node> nodes) {
        for (Node n : nodes) {
            this.setNodeConcurrentToNodes(n, nodes);
        }
    }

    protected void setNodeConcurrentToNodes(Node n, Collection<Node> nodes) {
        for (Node n2 : nodes) {
            this.setNodesConcurrent(n, n2);
        }
    }

    protected void setNodesConcurrent(Node n1, Node n2) {
        if (n1.equals(n2)) {
            return;
        }
        int index1 = this.nodes.indexOf(n1);
        int index2 = this.nodes.indexOf(n2);
        this.matrix[index1][index2] = true;
        this.matrix[index2][index1] = true;
    }

    protected void processConcNodes(Set<NodePair> concNodes, boolean isFC) {
        for (NodePair pair : concNodes) {
            Node x = pair.getFirstNode();
            Node p = pair.getSecondNode();
            if (isFC) {
                Node t;
                if (this.sys.getPostset(p).isEmpty() || !this.nodeConcurrentToNodes(x, this.sys.getPreset(t = this.sys.getPostset(p).iterator().next()))) continue;
                Set<Node> sucP = this.sys.getPostset(p);
                HashSet<NodePair> concNodes2 = new HashSet<NodePair>();
                if (x instanceof Place) {
                    for (Node u : sucP) {
                        if (this.areConcurrent(x, u)) continue;
                        concNodes2.add(new NodePair(u, x));
                    }
                }
                for (Node pp : this.indirectPlaces.get(p)) {
                    if (this.areConcurrent(x, pp)) continue;
                    concNodes2.add(new NodePair(x, pp));
                    if (!(x instanceof Place)) continue;
                    concNodes2.add(new NodePair(pp, x));
                }
                this.setNodeConcurrentToNodes(x, sucP);
                this.setNodeConcurrentToNodes(x, (Collection<Node>)this.indirectPlaces.get(p));
                this.processConcNodes(concNodes2, isFC);
                continue;
            }
            for (Node t : this.sys.getPostset(p)) {
                if (!this.nodeConcurrentToNodes(x, this.sys.getPreset(t))) continue;
                Set<Node> sucT = this.sys.getPostset(t);
                HashSet<NodePair> concNodes2 = new HashSet<NodePair>();
                for (Node s : sucT) {
                    if (this.areConcurrent(x, s)) continue;
                    concNodes2.add(new NodePair(x, s));
                    if (!(x instanceof Place)) continue;
                    concNodes2.add(new NodePair(s, x));
                }
                if (x instanceof Place) {
                    concNodes2.add(new NodePair(t, x));
                }
                this.setNodeConcurrentToNodes(x, sucT);
                this.setNodesConcurrent(x, t);
                this.processConcNodes(concNodes2, isFC);
            }
        }
    }

    protected void addAllCombinations(Set<NodePair> combinations, List<Node> nodes) {
        int i = 0;
        while (i < nodes.size()) {
            int j = i + 1;
            while (j < nodes.size()) {
                combinations.add(new NodePair(nodes.get(i), nodes.get(j)));
                combinations.add(new NodePair(nodes.get(j), nodes.get(i)));
                ++j;
            }
            ++i;
        }
    }

    protected void calculateConcurrencyMatrix() {
        this.matrix = new boolean[this.nodes.size()][this.nodes.size()];
        HashSet<NodePair> concNodes = new HashSet<NodePair>();
        ArrayList<Node> initialPlaces = new ArrayList<Node>(this.sys.getMarkedPlaces());
        this.setAllNodesConcurrent(initialPlaces);
        this.addAllCombinations(concNodes, initialPlaces);
        for (Transition t1 : this.sys.getTransitions()) {
            ArrayList<Node> outPlaces = new ArrayList<Node>(this.sys.getPostset(t1));
            this.setAllNodesConcurrent(outPlaces);
            this.addAllCombinations(concNodes, outPlaces);
        }
        if (PetriNet.STRUCTURAL_CHECKS.isExtendedFreeChoice(this.sys)) {
            for (Node n : this.nodes) {
                if (!(n instanceof Place)) continue;
                HashSet<Node> nodes = new HashSet<Node>();
                for (Node t2 : this.sys.getPostset(n)) {
                    for (Node n2 : this.sys.getPostset(t2)) {
                        nodes.add(n2);
                    }
                }
                this.indirectPlaces.put(n, nodes);
            }
        }
        this.processConcNodes(concNodes, PetriNet.STRUCTURAL_CHECKS.isExtendedFreeChoice(this.sys));
    }

    public String toString() {
        if (this.matrix == null) {
            this.calculateConcurrencyMatrix();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("------------------------------------------\n");
        sb.append("True Concurrency Matrix\n");
        sb.append("------------------------------------------\n");
        int k = 0;
        while (k < this.matrix.length) {
            int row = 0;
            while (row < this.matrix.length) {
                sb.append(String.valueOf(this.matrix[row][k]) + " , ");
                ++row;
            }
            sb.append("\n");
            ++k;
        }
        sb.append("------------------------------------------\n");
        return sb.toString();
    }

    public NetSystem getNet() {
        return this.sys;
    }

    public boolean equals(ConcurrencyRelation relation) {
        if (!this.sys.equals(relation.getNet())) {
            return false;
        }
        boolean equal = true;
        for (Node n1 : this.nodes) {
            for (Node n2 : this.nodes) {
                equal &= this.areConcurrent(n1, n2) == relation.areConcurrent(n1, n2);
            }
        }
        return equal;
    }

    private class NodePair {
        private Node n1;
        private Node n2;

        public NodePair(Node n1, Node n2) {
            this.n1 = n1;
            this.n2 = n2;
        }

        public Node getFirstNode() {
            return this.n1;
        }

        public Node getSecondNode() {
            return this.n2;
        }

        public String toString() {
            return "(" + this.n1.toString() + " | " + this.n2.toString() + ")";
        }
    }
}

