/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.behavior;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.behavior.LolaSoundnessCheckerResult;
import org.jbpt.petri.io.PNMLSerializer;
import org.jbpt.throwable.SerializationException;

public class LolaSoundnessChecker {
    private static final String LOLA_URI = "http://esla.informatik.uni-rostock.de/service-tech/.lola/lola.php";
    private static int TIMEOUT = 180000;
    private static int N = 5;

    public static LolaSoundnessCheckerResult analyzeSoundness(NetSystem net) throws SerializationException, IOException {
        String pnml = PNMLSerializer.serializePetriNet(net, PNMLSerializer.LOLA);
        LolaSoundnessCheckerResult result = new LolaSoundnessCheckerResult();
        int i = 0;
        while (i < N) {
            block4: {
                String response = LolaSoundnessChecker.callLola(pnml, LOLA_URI);
                try {
                    result.parseResult(response, net);
                }
                catch (IllegalArgumentException e) {
                    if (i == N - 1) {
                        throw new IOException("Lola service failure!");
                    }
                    break block4;
                }
                return result;
            }
            ++i;
        }
        return result;
    }

    private static String callLola(String pnml, String address) throws IOException {
        String line;
        URL url = new URL(address);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setReadTimeout(TIMEOUT);
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        writer.write("input=" + URLEncoder.encode(pnml, "UTF-8"));
        writer.flush();
        StringBuffer answer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = reader.readLine()) != null) {
            answer.append(line);
        }
        writer.close();
        reader.close();
        return answer.toString();
    }
}

