/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;

public class LolaSoundnessCheckerResult {
    private boolean boundedness = false;
    private Collection<Transition> deadTransitions = new ArrayList<Transition>();
    private boolean liveness = false;
    private boolean quasiLiveness = false;
    private boolean relaxedSoundness = false;
    private boolean soundness = false;
    private boolean transitioncover = false;
    private Collection<Place> unboundedPlaces = new ArrayList<Place>();
    private Collection<Transition> uncoveredTransitions = new ArrayList<Transition>();
    private boolean weaksoundness = false;

    public void addDeadTransition(Transition deadTransition) {
        this.deadTransitions.add(deadTransition);
    }

    public void addUnboundedPlace(Place unboundedPlace) {
        this.unboundedPlaces.add(unboundedPlace);
    }

    public void addUncoveredTransition(Transition uncoveredtransition) {
        this.uncoveredTransitions.add(uncoveredtransition);
    }

    public Collection<Transition> getDeadTransitions() {
        return this.deadTransitions;
    }

    public Collection<Place> getUnboundedPlaces() {
        return this.unboundedPlaces;
    }

    public Collection<Transition> getUncoveredTransitions() {
        return this.uncoveredTransitions;
    }

    public boolean hasLiveness() {
        return this.liveness;
    }

    public boolean hasTransitioncover() {
        return this.transitioncover;
    }

    public boolean isBounded() {
        return this.boundedness;
    }

    public boolean isClassicalSound() {
        return this.soundness;
    }

    public boolean hasQuasiLiveness() {
        return this.quasiLiveness;
    }

    public boolean isRelaxedSound() {
        return this.relaxedSoundness;
    }

    public boolean isWeakSound() {
        return this.weaksoundness;
    }

    public void parseResult(String lolaResponse, NetSystem analyzedNet) {
        if (lolaResponse.toLowerCase().matches(".*warning.*")) {
            throw new IllegalArgumentException("Warning in response!");
        }
        String[] responseParts = lolaResponse.split(";");
        int i = 0;
        while (i < responseParts.length) {
            String responsePart = responseParts[i].toLowerCase();
            if (responsePart.matches("uncoveredtransitions .*")) {
                this.uncoveredTransitions = this.getTransitions(responseParts[i].split("\""), analyzedNet);
            } else if (responsePart.matches("deadtransitions .*")) {
                this.deadTransitions = this.getTransitions(responseParts[i].split("\""), analyzedNet);
            } else if (responsePart.matches("unboundedplaces .*")) {
                this.unboundedPlaces = this.getPlaces(responseParts[i].split("\""), analyzedNet);
            } else if (responsePart.matches("soundness = true")) {
                this.setClassicalSoundness(true);
            } else if (responsePart.matches("weaksoundness = true")) {
                this.setWeakSoundness(true);
            } else if (responsePart.matches("relaxedsoundness = true")) {
                this.setRelaxedSoundness(true);
            } else if (responsePart.matches("liveness = true")) {
                this.setLiveness(true);
            } else if (responsePart.matches("boundedness = true")) {
                this.setBoundedness(true);
            } else if (responsePart.matches("transitioncover = true")) {
                this.setTransitioncover(true);
            } else if (responsePart.matches("quasiliveness = true")) {
                this.setQuasiLiveness(true);
            }
            ++i;
        }
    }

    public void setBoundedness(boolean boundedness) {
        this.boundedness = boundedness;
    }

    public void setClassicalSoundness(boolean soundness) {
        this.soundness = soundness;
    }

    public void setDeadTransitions(Collection<Transition> deadTransitions) {
        this.deadTransitions = deadTransitions;
    }

    public void setLiveness(boolean liveness) {
        this.liveness = liveness;
    }

    public void setQuasiLiveness(boolean quasiLiveness) {
        this.quasiLiveness = quasiLiveness;
    }

    public void setRelaxedSoundness(boolean relaxedSoundness) {
        this.relaxedSoundness = relaxedSoundness;
    }

    public void setTransitioncover(boolean transitioncover) {
        this.transitioncover = transitioncover;
    }

    public void setUnboundedPlaces(Collection<Place> unboundedPlaces) {
        this.unboundedPlaces = unboundedPlaces;
    }

    public void setUncoveredTransitions(Collection<Transition> uncoveredTransitions) {
        this.uncoveredTransitions = uncoveredTransitions;
    }

    public void setWeakSoundness(boolean weaksoundness) {
        this.weaksoundness = weaksoundness;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("boundedness=");
        builder.append(this.isBounded());
        builder.append(", liveness=");
        builder.append(this.hasLiveness());
        builder.append(", quasi liveness=");
        builder.append(this.hasQuasiLiveness());
        builder.append(", relaxed sound=");
        builder.append(this.isRelaxedSound());
        builder.append(", weak sound=");
        builder.append(this.isWeakSound());
        builder.append(", classical sound=");
        builder.append(this.isClassicalSound());
        builder.append(", transitioncover=");
        builder.append(this.hasTransitioncover());
        builder.append(", dead transitions=");
        builder.append(this.getDeadTransitions().toString());
        builder.append(", uncovered transitions=");
        builder.append(this.getUncoveredTransitions().toString());
        builder.append(", unbounded places=");
        builder.append(this.getUnboundedPlaces().toString());
        return builder.toString();
    }

    private Collection<Place> getPlaces(String[] placeNames, NetSystem analyzedNet) {
        ArrayList<Place> result = new ArrayList<Place>();
        Set places = analyzedNet.getPlaces();
        int i = 1;
        while (i < placeNames.length) {
            if (!placeNames[i].equals("")) {
                for (Place place : places) {
                    if (!place.getId().equals(placeNames[i])) continue;
                    result.add(place);
                }
            }
            i += 2;
        }
        return result;
    }

    private Collection<Transition> getTransitions(String[] transitionNames, NetSystem analyzedNet) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        Set transitions = analyzedNet.getTransitions();
        int i = 1;
        while (i < transitionNames.length) {
            if (!transitionNames[i].equals("")) {
                for (Transition transition : transitions) {
                    if (!transition.getId().equals(transitionNames[i])) continue;
                    result.add(transition);
                }
            }
            i += 2;
        }
        return result;
    }
}

