/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;

public class ProjectedStateSpace<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>> {
    protected INetSystem<F, N, P, T, M> netSystem = null;
    protected Map<M, Set<T>> enabled = null;
    protected Map<T, Set<M>> txM = null;
    protected Map<T, Set<M>> vTxM = null;
    protected Map<M, Map<T, M>> stateTransitions = null;
    protected boolean[][] stepMatrix = null;
    protected Map<T, Integer> projectionSetForStepMatrix = null;

    public ProjectedStateSpace(INetSystem<F, N, P, T, M> netSystem, Set<T> projectionSet) {
        this.netSystem = netSystem;
        this.enabled = new HashMap<M, Set<T>>();
        this.txM = new HashMap<T, Set<M>>();
        this.vTxM = new HashMap<T, Set<M>>();
        this.stateTransitions = new HashMap<M, Map<T, M>>();
        this.projectionSetForStepMatrix = new HashMap<T, Integer>();
        ArrayList<T> tmpList = new ArrayList<T>(projectionSet);
        int i = 0;
        while (i < tmpList.size()) {
            this.projectionSetForStepMatrix.put((ITransition)tmpList.get(i), i);
            ++i;
        }
        this.stepMatrix = new boolean[this.projectionSetForStepMatrix.keySet().size()][this.projectionSetForStepMatrix.keySet().size()];
        i = 0;
        while (i < this.projectionSetForStepMatrix.keySet().size()) {
            this.stepMatrix[i][i] = false;
            int j = i + 1;
            while (j < this.projectionSetForStepMatrix.keySet().size()) {
                this.stepMatrix[i][j] = false;
                this.stepMatrix[j][i] = false;
                ++j;
            }
            ++i;
        }
    }

    public void create() {
        this.createUpToNumberOfMarkings(Integer.MAX_VALUE);
    }

    public void createUpToNumberOfMarkings(int numberOfMarkings) {
        IMarking iM = this.netSystem.getMarking().clone();
        HashSet<T> iEnabled = new HashSet<T>(this.netSystem.getEnabledTransitions());
        this.enabled.put(iM, iEnabled);
        for (ITransition t : this.netSystem.getTransitions()) {
            this.vTxM.put(t, new HashSet());
        }
        for (ITransition t : iEnabled) {
            IMarking nM = this.fireTransition(iM, iEnabled, t);
            this.addToVisit(t, nM);
        }
        while (!this.txM.isEmpty() && this.getNumberOfMarkings() < numberOfMarkings) {
            ITransition t;
            t = (ITransition)this.txM.keySet().iterator().next();
            if (this.txM.get(t).isEmpty()) {
                this.txM.remove(t);
                continue;
            }
            IMarking m = (IMarking)this.txM.get(t).iterator().next();
            this.txM.get(t).remove(m);
            this.vTxM.get(t).add(m);
            for (ITransition te : this.enabled.get(m)) {
                IMarking nM = this.fireTransition(m, this.enabled.get(m), te);
                if (this.projectionSetForStepMatrix.keySet().contains(te)) {
                    if (this.projectionSetForStepMatrix.keySet().contains(t)) {
                        this.addStep(t, te);
                    }
                    if (this.visited(te, nM)) continue;
                    this.addToVisit(te, nM);
                    continue;
                }
                if (this.visited(t, nM)) continue;
                this.addToVisit(t, nM);
            }
        }
        this.netSystem.loadMarking(iM);
    }

    protected void addToVisit(T t, M m) {
        if (!this.txM.containsKey(t)) {
            this.txM.put(t, new HashSet());
        }
        this.txM.get(t).add(m);
    }

    protected boolean visited(T t, M m) {
        return this.vTxM.get(t).contains(m);
    }

    protected M fireTransition(M from, Set<T> enabled, T t) {
        this.netSystem.loadMarking(from);
        this.netSystem.fire(t);
        IMarking nM = this.netSystem.getMarking().clone();
        if (!this.enabled.containsKey(nM)) {
            Set<T> nEnabled = this.netSystem.getEnabledTransitions(enabled, t);
            this.enabled.put(nM, nEnabled);
        }
        if (!this.stateTransitions.containsKey(from)) {
            this.stateTransitions.put(from, new HashMap());
        }
        this.stateTransitions.get(from).put(t, nM);
        return (M)nM;
    }

    public int getNumberOfMarkings() {
        return this.enabled.keySet().size();
    }

    public void addStep(T t1, T t2) {
        this.stepMatrix[this.projectionSetForStepMatrix.get(t1).intValue()][this.projectionSetForStepMatrix.get(t2).intValue()] = true;
    }

    public boolean isStep(N t1, N t2) {
        if (!this.projectionSetForStepMatrix.keySet().contains(t1) || !this.projectionSetForStepMatrix.keySet().contains(t2)) {
            throw new IllegalArgumentException("Transitions have not been in projection set.");
        }
        return this.stepMatrix[this.projectionSetForStepMatrix.get(t1)][this.projectionSetForStepMatrix.get(t2)];
    }
}

