/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;

public class SimpleStateSpace<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>> {
    protected INetSystem<F, N, P, T, M> netSystem = null;
    protected Map<M, Set<T>> enabled = null;
    protected Map<M, Set<T>> toVisit = null;
    protected Map<M, Map<T, M>> stateTransitions = null;

    public SimpleStateSpace(INetSystem<F, N, P, T, M> netSystem) {
        this.netSystem = netSystem;
        this.enabled = new HashMap<M, Set<T>>();
        this.toVisit = new HashMap<M, Set<T>>();
        this.stateTransitions = new HashMap<M, Map<T, M>>();
    }

    public void create() {
        this.createUpToNumberOfMarkings(Integer.MAX_VALUE);
    }

    public void createUpToNumberOfMarkings(int numberOfMarkings) {
        IMarking iM = this.netSystem.getMarking().clone();
        this.enabled.put(iM, this.netSystem.getEnabledTransitions());
        this.toVisit.put(iM, this.netSystem.getEnabledTransitions());
        while (!this.toVisit.isEmpty() && this.getNumberOfMarkings() < numberOfMarkings) {
            IMarking m = (IMarking)this.toVisit.keySet().iterator().next();
            if (this.toVisit.get(m).isEmpty()) {
                this.toVisit.remove(m);
                continue;
            }
            ITransition t = (ITransition)this.toVisit.get(m).iterator().next();
            this.netSystem.loadMarking(m);
            this.netSystem.fire(t);
            this.toVisit.get(m).remove(t);
            IMarking nM = this.netSystem.getMarking().clone();
            if (!this.stateTransitions.containsKey(m)) {
                this.stateTransitions.put(m, new HashMap());
            }
            this.stateTransitions.get(m).put(t, nM);
            Set<ITransition> nEnabled = this.netSystem.getEnabledTransitions(this.enabled.get(m), t);
            this.enabled.put(nM, nEnabled);
            HashSet<ITransition> stillToCheck = new HashSet<ITransition>(nEnabled);
            if (this.stateTransitions.containsKey(nM)) {
                stillToCheck.removeAll(this.stateTransitions.get(nM).keySet());
            }
            if (stillToCheck.isEmpty()) continue;
            this.toVisit.put(nM, stillToCheck);
        }
        this.netSystem.loadMarking(iM);
    }

    public void clear() {
        this.enabled = new HashMap<M, Set<T>>();
        this.toVisit = new HashMap<M, Set<T>>();
        this.stateTransitions = new HashMap<M, Map<T, M>>();
    }

    public String toDOT() {
        String result = "digraph G {\n";
        result = String.valueOf(result) + "graph [fontname=\"Helvetica\" fontsize=10 nodesep=0.35 ranksep=\"0.25 equally\"];\n";
        result = String.valueOf(result) + "node [fontname=\"Helvetica\" fontsize=10 fixedsize style=filled fillcolor=white penwidth=\"2\"];\n";
        result = String.valueOf(result) + "edge [fontname=\"Helvetica\" fontsize=10 arrowhead=normal color=black];\n";
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=circle];\n";
        ArrayList<M> tmpMarkings = new ArrayList<M>(this.enabled.keySet());
        int i = 0;
        while (i < tmpMarkings.size()) {
            result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".3\" height=\".3\"];\n", i, ((IMarking)tmpMarkings.get(i)).toString());
            ++i;
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "\n";
        for (IMarking m1 : this.stateTransitions.keySet()) {
            for (Map.Entry<T, M> step : this.stateTransitions.get(m1).entrySet()) {
                result = String.valueOf(result) + String.format("\tn%s->n%s [label=\"%s\"];\n", tmpMarkings.indexOf(m1), tmpMarkings.indexOf(step.getValue()), ((ITransition)step.getKey()).getLabel());
            }
        }
        result = String.valueOf(result) + "}\n";
        return result;
    }

    public int getNumberOfMarkings() {
        return this.enabled.keySet().size();
    }
}

