/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpt.petri.Flow;
import org.jbpt.petri.Marking;
import org.jbpt.petri.NetSystem;
import org.jbpt.petri.Node;
import org.jbpt.petri.Place;
import org.jbpt.petri.Transition;
import org.jbpt.throwable.SerializationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PNMLSerializer
extends DefaultHandler {
    public static int DEFAULT = 0;
    public static int LOLA = 1;
    private boolean place;
    private boolean placeName;
    private boolean placeNameText;
    private boolean placeMarking;
    private boolean placeMarkingText;
    private boolean arc;
    private boolean transition;
    private boolean transitionName;
    private boolean transitionNameText;
    private boolean toolspecific;
    private NetSystem pn;
    private HashMap<String, Node> nodes;
    private String currentTransitionID;
    private String currentPlaceID;

    public void clear() {
        this.pn = new NetSystem();
        this.nodes = new HashMap();
        this.place = false;
        this.placeName = false;
        this.placeNameText = false;
        this.placeMarking = false;
        this.placeMarkingText = false;
        this.arc = false;
        this.toolspecific = false;
        this.transition = false;
        this.transitionName = false;
        this.transitionNameText = false;
        this.currentTransitionID = "";
        this.currentPlaceID = "";
    }

    public NetSystem parse(byte[] pnmlContent) {
        return this.parseContent(null, pnmlContent);
    }

    public NetSystem parse(String file) {
        return this.parseContent(file, null);
    }

    private NetSystem parseContent(String file, byte[] pnmlContent) {
        this.clear();
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setContentHandler(this);
            xmlReader.setDTDHandler(this);
            xmlReader.setErrorHandler(this);
            try {
                if (file != null) {
                    FileInputStream fileStream = new FileInputStream(file);
                    InputSource is = new InputSource(fileStream);
                    xmlReader.parse(is);
                } else if (pnmlContent != null) {
                    StringReader inStream = new StringReader(new String(pnmlContent));
                    InputSource is = new InputSource(inStream);
                    xmlReader.parse(is);
                }
            }
            catch (IOException e) {
                System.out.println("Error reading PNML-File.");
            }
        }
        catch (SAXException e) {
            System.out.println("SAX Exception: " + e.getMessage());
        }
        return this.pn;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.placeName) {
            this.placeNameText = localName.equals("text");
        } else if (this.placeMarking) {
            this.placeMarkingText = localName.equals("text");
        } else if (this.transitionName) {
            this.transitionNameText = localName.equals("text");
        } else if (!this.arc && !this.toolspecific) {
            if (this.place) {
                if (localName.equals("name")) {
                    this.placeName = true;
                } else if (localName.equals("initialMarking")) {
                    this.placeMarking = true;
                }
            } else if (this.transition && localName.equals("name")) {
                this.transitionName = true;
            }
        }
        if (localName.equals("arc")) {
            this.arc = true;
            this.pn.addFlow(this.nodes.get(attributes.getValue(1)), this.nodes.get(attributes.getValue(2)));
        } else if (localName.equals("place")) {
            this.place = true;
            Place p = new Place(attributes.getValue(0));
            p.setId(attributes.getValue(0));
            p.setName("");
            this.nodes.put(p.getId(), p);
            this.pn.addPlace(p);
            this.currentPlaceID = p.getId();
        } else if (localName.equals("transition")) {
            this.transition = true;
            Transition t = new Transition();
            t.setId(attributes.getValue(0));
            t.setName("");
            this.nodes.put(t.getId(), t);
            this.pn.addTransition(t);
            this.currentTransitionID = t.getId();
        } else if (localName.equals("toolspecific")) {
            this.toolspecific = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.placeNameText) {
            char[] text = new char[length];
            System.arraycopy(ch, start, text, 0, length);
            String name = String.valueOf(this.nodes.get(this.currentPlaceID).getName()) + new String(text);
            this.nodes.get(this.currentPlaceID).setName(name);
        } else if (this.placeMarkingText) {
            char[] text = new char[length];
            System.arraycopy(ch, start, text, 0, length);
            ((Marking)this.pn.getMarking()).put((Place)this.nodes.get(this.currentPlaceID), Integer.valueOf(new String(text)));
        } else if (this.transitionNameText) {
            char[] text = new char[length];
            System.arraycopy(ch, start, text, 0, length);
            String name = String.valueOf(this.nodes.get(this.currentTransitionID).getName()) + new String(text);
            this.nodes.get(this.currentTransitionID).setLabel(name);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (localName.equals("text")) {
            if (this.transitionNameText) {
                this.transitionNameText = false;
                String name = this.normalizeTransitionLabel(this.nodes.get(this.currentTransitionID).getName());
                this.nodes.get(this.currentTransitionID).setName(name);
            } else if (this.placeNameText) {
                this.placeNameText = false;
            } else if (this.placeMarkingText) {
                this.placeMarkingText = false;
            }
        } else if (localName.equals("name")) {
            if (this.transitionName) {
                this.transitionName = false;
            } else if (this.placeName) {
                this.placeName = false;
            }
        } else if (localName.equals("initialMarking")) {
            this.placeMarking = false;
        } else if (localName.equals("arc")) {
            this.arc = false;
        } else if (localName.equals("place")) {
            this.place = false;
        } else if (localName.equals("transition")) {
            this.transition = false;
        } else if (localName.equals("toolspecific")) {
            this.toolspecific = false;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(this.saxMsg(e));
    }

    private String saxMsg(SAXParseException e) {
        return "Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber() + ", Error: " + e.getMessage();
    }

    private String normalizeTransitionLabel(String label) {
        String result = label.replace("\n", " ");
        result = result.trim();
        return result;
    }

    public static String serializePetriNet(NetSystem net) throws SerializationException {
        return PNMLSerializer.serializePetriNet(net, DEFAULT);
    }

    public static String serializePetriNet(NetSystem net, int tool) throws SerializationException {
        Document doc = PNMLSerializer.serialize(net, tool);
        if (doc == null) {
            return null;
        }
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(new StringWriter());
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer serializer = tf.newTransformer();
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new SerializationException(e.getMessage());
        }
        return ((StringWriter)streamResult.getWriter()).getBuffer().toString();
    }

    public static Document serialize(NetSystem net) throws SerializationException {
        return PNMLSerializer.serialize(net, DEFAULT);
    }

    public static Document serialize(NetSystem net, int tool) throws SerializationException {
        if (net == null) {
            return null;
        }
        DocumentBuilderFactory docBFac = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder docBuild = docBFac.newDocumentBuilder();
            DOMImplementation impl = docBuild.getDOMImplementation();
            doc = impl.createDocument("http://www.pnml.org/version-2009/grammar/pnml", "pnml", null);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new SerializationException(e.getMessage());
        }
        Element root = doc.getDocumentElement();
        Element netNode = doc.createElement("net");
        root.appendChild(netNode);
        if (!net.getId().equals("")) {
            netNode.setAttribute("id", net.getId());
        } else {
            netNode.setAttribute("id", "ptnet");
        }
        netNode.setAttribute("type", "http://www.pnml.org/version-2009/grammar/ptnet");
        PNMLSerializer.addElementWithText(doc, netNode, "name", net.getName());
        Element page = doc.createElement("page");
        page.setAttribute("id", "page0");
        netNode.appendChild(page);
        for (Place place : net.getPlaces()) {
            PNMLSerializer.addPlace(doc, page, net, place);
        }
        for (Transition trans : net.getTransitions()) {
            PNMLSerializer.addTransition(doc, page, trans);
        }
        for (Flow flow : net.getFlow()) {
            PNMLSerializer.addFlow(doc, page, flow);
        }
        if (tool == LOLA) {
            PNMLSerializer.addFinalMarkings(doc, page, net);
        }
        return doc;
    }

    private static Element addElementWithText(Document doc, Element parent, String tag, String content) {
        Element elem = doc.createElement(tag);
        Element text = doc.createElement("text");
        text.setTextContent(content);
        elem.appendChild(text);
        parent.appendChild(elem);
        return elem;
    }

    private static void addPlace(Document doc, Element parent, NetSystem net, Place place) {
        Element elem = doc.createElement("place");
        elem.setAttribute("id", place.getId());
        if (!place.getName().equals("")) {
            PNMLSerializer.addElementWithText(doc, elem, "name", place.getName());
        }
        if (net.getTokens(place) > 0) {
            PNMLSerializer.addElementWithText(doc, elem, "initialMarking", String.valueOf(net.getTokens(place)));
        }
        parent.appendChild(elem);
    }

    private static void addTransition(Document doc, Element parent, Transition trans) {
        Element elem = doc.createElement("transition");
        elem.setAttribute("id", trans.getId());
        if (!trans.getName().equals("")) {
            PNMLSerializer.addElementWithText(doc, elem, "name", trans.getName());
        }
        parent.appendChild(elem);
    }

    private static void addFlow(Document doc, Element parent, Flow flow) {
        Element elem = doc.createElement("arc");
        elem.setAttribute("id", flow.getId());
        elem.setAttribute("source", ((Node)flow.getSource()).getId());
        elem.setAttribute("target", ((Node)flow.getTarget()).getId());
        if (!flow.getName().equals("")) {
            PNMLSerializer.addElementWithText(doc, elem, "name", flow.getName());
        }
        parent.appendChild(elem);
    }

    private static void addFinalMarkings(Document doc, Element parent, NetSystem net) {
        Element finalMarkings = doc.createElement("finalmarkings");
        for (Place place : net.getSinkPlaces()) {
            Element elem = PNMLSerializer.addElementWithText(doc, finalMarkings, "place", "1");
            elem.setAttribute("idref", place.getId());
            Element marking = doc.createElement("marking");
            marking.appendChild(elem);
            finalMarkings.appendChild(marking);
        }
        parent.appendChild(finalMarkings);
    }
}

