/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.structure;

import java.util.HashSet;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;

public class PetriNetProjector<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition> {
    public void reducePetriNetBasedOnProjectionSet(IPetriNet<F, N, P, T> pn, Set<T> projectionSet) {
        Set<IPlace> sucTs;
        IPlace p;
        Object parallel;
        Set<ITransition> pre;
        HashSet<T> notInProjectionSet = new HashSet<T>(pn.getTransitions());
        notInProjectionSet.removeAll(projectionSet);
        for (ITransition t : notInProjectionSet) {
            IPlace pre_p;
            Set<IPlace> possiblyConcurrentTransitions;
            pre = pn.getPreset((IPlace)((Object)t));
            if (pre.size() != 1 || (possiblyConcurrentTransitions = pn.getPostset(pre_p = (IPlace)((Object)pre.iterator().next()))).size() >= 2 || pn.getPostset((IPlace)((Object)t)).size() >= 2) continue;
            this.applyReductionRuleA(pn, t);
        }
        for (ITransition t : notInProjectionSet) {
            Set<ITransition> suc = pn.getPostset((IPlace)((Object)t));
            if (suc.size() != 1 || (parallel = pn.getPreset(p = (IPlace)((Object)suc.iterator().next()))).size() >= 2 || (sucTs = pn.getPostset(p)).size() != 1) continue;
            this.applyReductionRuleB(pn, t);
        }
        for (ITransition t : notInProjectionSet) {
            Set<ITransition> placeSet;
            Set<IPlace> preT;
            pre = pn.getPreset((IPlace)((Object)t));
            if (pre.size() != 1 || (parallel = pn.getPostset(p = (IPlace)((Object)pre.iterator().next()))).size() >= 2 || (preT = pn.getPreset(p)).size() != 1 || (placeSet = pn.getPostset((IPlace)((Object)((ITransition)((Object)preT.iterator().next()))))).size() >= 2) continue;
            this.applyReductionRuleC(pn, t);
        }
        HashSet<IPlace> pToRemove = new HashSet<IPlace>();
        for (IPlace p1 : pn.getPlaces()) {
            if (pToRemove.contains(p1)) continue;
            for (IPlace p2 : pn.getPlaces()) {
                if (p1.equals(p2)) continue;
                Set<IPlace> preset = pn.getPreset(p1);
                Set<IPlace> postset = pn.getPostset(p1);
                Set<IPlace> preset2 = pn.getPreset(p2);
                Set<IPlace> postset2 = pn.getPostset(p2);
                if (preset.size() != 1 || postset.size() != 1 || preset2.size() != 1 || postset2.size() != 1 || !preset.equals(preset2) || !postset.equals(postset2)) continue;
                pToRemove.add(p2);
            }
        }
        pn.removePlaces(pToRemove);
        HashSet<ITransition> tToRemove = new HashSet<ITransition>();
        for (ITransition t1 : pn.getTransitions()) {
            if (tToRemove.contains(t1)) continue;
            for (ITransition t2 : notInProjectionSet) {
                if (t1.equals(t2)) continue;
                Set<ITransition> preset = pn.getPreset((IPlace)((Object)t1));
                Set<ITransition> postset = pn.getPostset((IPlace)((Object)t1));
                Set<ITransition> preset2 = pn.getPreset((IPlace)((Object)t2));
                Set<ITransition> postset2 = pn.getPostset((IPlace)((Object)t2));
                if (preset.size() != 1 || postset.size() != 1 || preset2.size() != 1 || postset2.size() != 1 || !preset.equals(preset2) || !postset.equals(postset2)) continue;
                tToRemove.add(t2);
            }
        }
        pn.removeTransitions(tToRemove);
        tToRemove = new HashSet();
        for (ITransition t : notInProjectionSet) {
            Set<ITransition> suc;
            Set<ITransition> pre2 = pn.getPreset((IPlace)((Object)t));
            if (!pre2.containsAll(suc = pn.getPostset((IPlace)((Object)t))) || !suc.containsAll(pre2)) continue;
            tToRemove.add(t);
        }
        pn.removeTransitions(tToRemove);
        pToRemove = new HashSet();
        for (IPlace p2 : pn.getPlaces()) {
            Set<IPlace> preTs = pn.getPreset(p2);
            if (!preTs.containsAll(sucTs = pn.getPostset(p2)) || !sucTs.containsAll(preTs)) continue;
            pToRemove.add(p2);
        }
        pn.removePlaces(pToRemove);
    }

    private void applyReductionRuleA(IPetriNet<F, N, P, T> pn, T t) {
        IPlace pre = (IPlace)((Object)pn.getPreset((ITransition)t).iterator().next());
        Set<ITransition> pre_t = pn.getPreset((ITransition)((Object)pre));
        IPlace suc = (IPlace)((Object)pn.getPostset((ITransition)t).iterator().next());
        for (ITransition iTransition : pre_t) {
            pn.addFlow(iTransition, suc);
        }
        pn.removePlace(pre);
        pn.removeTransition((ITransition)t);
    }

    private void applyReductionRuleB(IPetriNet<F, N, P, T> pn, T t) {
        Set<N> prePlaces = pn.getPreset((IPlace)t);
        IPlace sucPlace = (IPlace)pn.getPostset((IPlace)t).iterator().next();
        ITransition sucT = (ITransition)((Object)pn.getPostset(sucPlace).iterator().next());
        for (IPlace node : prePlaces) {
            pn.addFlow(node, (IPlace)((Object)sucT));
        }
        pn.removeTransition((IPlace)t);
        pn.removePlace(sucPlace);
    }

    private void applyReductionRuleC(IPetriNet<F, N, P, T> pn, T t) {
        IPlace prePlace = (IPlace)pn.getPreset((ITransition)t).iterator().next();
        ITransition preT = (ITransition)((Object)pn.getPreset((ITransition)((Object)prePlace)).iterator().next());
        Set<N> sucPlaces = pn.getPostset((ITransition)t);
        for (IPlace node : sucPlaces) {
            pn.addFlow(preT, node);
        }
        pn.removeTransition((ITransition)t);
        pn.removePlace(prePlace);
    }
}

