/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.structure;

import org.jbpt.algo.graph.DirectedGraphAlgorithms;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;

public class PetriNetStructuralChecks<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition> {
    private DirectedGraphAlgorithms<F, N> DGA = new DirectedGraphAlgorithms();

    public boolean isFreeChoice(IPetriNet<F, N, P, T> net) {
        for (IPlace p : net.getPlaces()) {
            if (net.getPostset(p).size() <= 1 || net.getPresetPlaces(net.getPostset(p)).size() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isExtendedFreeChoice(IPetriNet<F, N, P, T> net) {
        boolean isFC = true;
        block0: for (ITransition t1 : net.getTransitions()) {
            for (ITransition t2 : net.getTransitions()) {
                for (IPlace p : net.getPlaces()) {
                    if (net.getPreset(t1).contains(p) && net.getPreset(t2).contains(p)) {
                        isFC &= net.getPreset(t1).equals(net.getPreset(t2));
                    }
                    if (!isFC) break block0;
                }
            }
        }
        return isFC;
    }

    public boolean isSNet(IPetriNet<F, N, P, T> net) {
        for (ITransition t : net.getTransitions()) {
            if (net.getPreset(t).size() == 1 && net.getPostset(t).size() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isTNet(IPetriNet<F, N, P, T> net) {
        for (IPlace p : net.getPlaces()) {
            if (net.getPreset(p).size() == 1 && net.getPostset(p).size() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isConflictFree(IPetriNet<F, N, P, T> net) {
        for (IPlace p : net.getPlaces()) {
            if (net.getPreset(p).size() <= 1 && net.getPostset(p).size() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isWorkflowNet(IPetriNet<F, N, P, T> net) {
        return this.DGA.isTwoTerminal(net);
    }

    public boolean isTRestricted(IPetriNet<F, N, P, T> net) {
        return net.getSourceTransitions().isEmpty() && net.getSinkTransitions().isEmpty();
    }
}

